/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.listeners;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.menu.CosmeticsInventoryHolder;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.run.FallDamageManager;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerListener
implements Listener {
    private final UltraCosmetics ultraCosmetics;

    public PlayerListener(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onJoin(final PlayerJoinEvent event) {
        new BukkitRunnable(){

            public void run() {
                if (SettingsManager.getConfig().getBoolean("Menu-Item.Enabled") && event.getPlayer().hasPermission("ultracosmetics.receivechest") && SettingsManager.isAllowedWorld(event.getPlayer().getWorld())) {
                    Bukkit.getScheduler().runTaskLater((Plugin)PlayerListener.this.ultraCosmetics, () -> {
                        UltraPlayer up = PlayerListener.this.ultraCosmetics.getPlayerManager().getUltraPlayer(event.getPlayer());
                        if (up != null) {
                            up.giveMenuItem();
                        }
                    }, 5L);
                }
                if (PlayerListener.this.ultraCosmetics.getUpdateChecker() != null && PlayerListener.this.ultraCosmetics.getUpdateChecker().isOutdated() && event.getPlayer().hasPermission("ultracosmetics.updatenotify")) {
                    event.getPlayer().sendMessage(MessageManager.getMessage("Prefix") + ChatColor.RED.toString() + ChatColor.BOLD + "An update is available: " + PlayerListener.this.ultraCosmetics.getUpdateChecker().getLastVersion());
                    event.getPlayer().sendMessage(MessageManager.getMessage("Prefix") + ChatColor.RED.toString() + ChatColor.BOLD + "Use " + ChatColor.YELLOW + "/uc update" + ChatColor.RED.toString() + ChatColor.BOLD + " to install the update.");
                }
            }
        }.runTaskAsynchronously((Plugin)this.ultraCosmetics);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        final UltraPlayer ultraPlayer = this.ultraCosmetics.getPlayerManager().getUltraPlayer(event.getPlayer());
        if (SettingsManager.isAllowedWorld(event.getPlayer().getWorld())) {
            if (SettingsManager.getConfig().getBoolean("Menu-Item.Enabled") && event.getPlayer().hasPermission("ultracosmetics.receivechest")) {
                this.ultraCosmetics.getPlayerManager().getUltraPlayer(event.getPlayer()).giveMenuItem();
            }
            new BukkitRunnable(){

                public void run() {
                    ultraPlayer.equipProfile();
                }
            }.runTaskLater((Plugin)this.ultraCosmetics, 5L);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onWorldChangeEarly(PlayerChangedWorldEvent event) {
        UltraPlayer ultraPlayer = this.ultraCosmetics.getPlayerManager().getUltraPlayer(event.getPlayer());
        if (!SettingsManager.isAllowedWorld(event.getPlayer().getWorld())) {
            ultraPlayer.removeMenuItem();
            ultraPlayer.setQuitting(true);
            if (ultraPlayer.clear()) {
                ultraPlayer.getBukkitPlayer().sendMessage(MessageManager.getMessage("World-Disabled"));
            }
            ultraPlayer.setQuitting(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onDrop(PlayerDropItemEvent event) {
        if (this.isMenuItem(event.getItemDrop().getItemStack())) {
            event.setCancelled(true);
            event.getItemDrop().remove();
            ItemStack chest = event.getPlayer().getItemInHand().clone();
            chest.setAmount(1);
            event.getPlayer().setItemInHand(chest);
            event.getPlayer().updateInventory();
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        UltraPlayer ultraPlayer = this.ultraCosmetics.getPlayerManager().getUltraPlayer(event.getPlayer());
        if (ultraPlayer == null) {
            return;
        }
        InventoryType t = event.getPlayer().getOpenInventory().getType();
        if (t != InventoryType.CRAFTING && t != InventoryType.CREATIVE) {
            return;
        }
        if (ultraPlayer.getCurrentTreasureChest() != null) {
            event.setCancelled(true);
            return;
        }
        if (this.isMenuItem(event.getItem())) {
            event.setCancelled(true);
            this.ultraCosmetics.getMenus().getMainMenu().open(ultraPlayer);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void cancelMove(InventoryClickEvent event) {
        boolean isMenuItem;
        Player player = (Player)event.getWhoClicked();
        if (!SettingsManager.isAllowedWorld(player.getWorld())) {
            return;
        }
        boolean bl = isMenuItem = this.isMenuItem(event.getCurrentItem()) || this.isMenuItem(event.getCursor()) || event.getClick() == ClickType.NUMBER_KEY && this.isMenuItem(player.getInventory().getItem(event.getHotbarButton()));
        if (event.getView().getTopInventory().getHolder() instanceof CosmeticsInventoryHolder || isMenuItem) {
            event.setCancelled(true);
            player.updateInventory();
            if (isMenuItem && SettingsManager.getConfig().getBoolean("Menu-Item.Open-Menu-On-Inventory-Click", false)) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.ultraCosmetics, () -> this.ultraCosmetics.getMenus().getMainMenu().open(this.ultraCosmetics.getPlayerManager().getUltraPlayer(player)), 1L);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void cancelMove(InventoryCreativeEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (!SettingsManager.isAllowedWorld(player.getWorld())) {
            return;
        }
        if (this.isMenuItem(event.getCurrentItem()) || this.isMenuItem(event.getCursor())) {
            event.setCancelled(true);
            player.closeInventory();
            if (SettingsManager.getConfig().getBoolean("Menu-Item.Open-Menu-On-Inventory-Click", false)) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.ultraCosmetics, () -> this.ultraCosmetics.getMenus().getMainMenu().open(this.ultraCosmetics.getPlayerManager().getUltraPlayer(player)), 1L);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void cancelMove(InventoryDragEvent event) {
        for (ItemStack item : event.getNewItems().values()) {
            if (!this.isMenuItem(item)) continue;
            event.setCancelled(true);
            ((Player)event.getWhoClicked()).updateInventory();
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onRespawn(PlayerRespawnEvent event) {
        if (SettingsManager.getConfig().getBoolean("Menu-Item.Enabled") && SettingsManager.isAllowedWorld(event.getPlayer().getWorld())) {
            int slot = SettingsManager.getConfig().getInt("Menu-Item.Slot");
            if (event.getPlayer().getInventory().getItem(slot) != null) {
                event.getPlayer().getWorld().dropItemNaturally(event.getPlayer().getLocation(), event.getPlayer().getInventory().getItem(slot));
                event.getPlayer().getInventory().setItem(slot, null);
            }
            String name = ChatColor.translateAlternateColorCodes((char)'&', (String)SettingsManager.getConfig().getString("Menu-Item.Displayname"));
            ItemStack stack = ItemFactory.getItemStackFromConfig("Menu-Item.Type");
            event.getPlayer().getInventory().setItem(slot, ItemFactory.rename(stack, name));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onQuit(PlayerQuitEvent event) {
        if (this.ultraCosmetics.getPlayerManager().getUltraPlayer(event.getPlayer()).getCurrentTreasureChest() != null) {
            this.ultraCosmetics.getPlayerManager().getUltraPlayer(event.getPlayer()).getCurrentTreasureChest().forceOpen(0);
        }
        UltraPlayer up = this.ultraCosmetics.getPlayerManager().getUltraPlayer(event.getPlayer());
        up.setQuitting(true);
        up.saveCosmeticsProfile();
        up.clear();
        up.removeMenuItem();
        Bukkit.getScheduler().runTaskLater((Plugin)this.ultraCosmetics, () -> this.ultraCosmetics.getPlayerManager().remove(event.getPlayer()), 1L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onDeath(PlayerDeathEvent event) {
        UltraPlayer ultraPlayer;
        if (Bukkit.getPlayer((UUID)event.getEntity().getUniqueId()) == null) {
            return;
        }
        int slot = SettingsManager.getConfig().getInt("Menu-Item.Slot");
        if (this.isMenuItem(event.getEntity().getInventory().getItem(slot))) {
            event.getDrops().remove(event.getEntity().getInventory().getItem(slot));
            event.getEntity().getInventory().setItem(slot, null);
        }
        if ((ultraPlayer = this.ultraCosmetics.getPlayerManager().getUltraPlayer(event.getEntity())).getCurrentGadget() != null) {
            event.getDrops().remove(event.getEntity().getInventory().getItem(((Integer)SettingsManager.getConfig().get("Gadget-Slot")).intValue()));
        }
        if (ultraPlayer.getCurrentHat() != null) {
            event.getDrops().remove(ultraPlayer.getCurrentHat().getItemStack());
        }
        Arrays.asList(ArmorSlot.values()).forEach(armorSlot -> {
            if (ultraPlayer.getSuit((ArmorSlot)((Object)armorSlot)) != null) {
                event.getDrops().remove(ultraPlayer.getSuit((ArmorSlot)((Object)armorSlot)).getItemStack());
            }
        });
        if (ultraPlayer.getCurrentEmote() != null) {
            event.getDrops().remove(ultraPlayer.getCurrentEmote().getItemStack());
        }
        ultraPlayer.clear();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL && FallDamageManager.shouldBeProtected(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Firework && event.getDamager().hasMetadata("UCFirework")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerPickUpItem(PlayerPickupItemEvent event) {
        if (this.isMenuItem(event.getItem().getItemStack())) {
            event.setCancelled(true);
            event.getItem().remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteractGhost(PlayerInteractAtEntityEvent event) {
        if (event.getRightClicked() != null && event.getRightClicked().hasMetadata("C_AD_ArmorStand")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        if (event.getPlayer().hasPermission("ultracosmetics.bypass.disabledcommands")) {
            return;
        }
        String strippedCommand = event.getMessage().split(" ")[0].replace("/", "").toLowerCase();
        if (!SettingsManager.getConfig().getList("Disabled-Commands").contains(strippedCommand)) {
            return;
        }
        UltraPlayer player = this.ultraCosmetics.getPlayerManager().getUltraPlayer(event.getPlayer());
        if (player.hasCosmeticsEquipped()) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(MessageManager.getMessage("Disabled-Command-Message"));
        }
    }

    private boolean isMenuItem(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)String.valueOf(SettingsManager.getConfig().get("Menu-Item.Displayname"))));
    }
}

