/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.economy;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.economy.EconomyHook;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook
implements EconomyHook {
    private Economy economy = null;
    private boolean economyEnabled;

    public VaultHook(UltraCosmetics ultraCosmetics) {
        if (!ultraCosmetics.getServer().getPluginManager().isPluginEnabled("Vault")) {
            this.economyEnabled = false;
            return;
        }
        RegisteredServiceProvider economyProvider = ultraCosmetics.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.economy = (Economy)economyProvider.getProvider();
            ultraCosmetics.getSmartLogger().write("");
            ultraCosmetics.getSmartLogger().write("Hooked into Vault for economy: " + this.economy.getName());
            ultraCosmetics.getSmartLogger().write("");
            this.economyEnabled = true;
        } else {
            ultraCosmetics.getSmartLogger().write("");
            ultraCosmetics.getSmartLogger().write("Found Vault but no economy, please check whether your economy plugin supports Vault.");
            ultraCosmetics.getSmartLogger().write("");
            this.economyEnabled = false;
        }
    }

    @Override
    public void withdraw(Player player, int amount) {
        this.economy.withdrawPlayer((OfflinePlayer)player, (double)amount);
    }

    @Override
    public void deposit(Player player, int amount) {
        this.economy.depositPlayer((OfflinePlayer)player, (double)amount);
    }

    @Override
    public double balance(Player player) {
        return this.economy.getBalance((OfflinePlayer)player);
    }

    @Override
    public String getName() {
        return "Vault:" + this.economy.getName();
    }

    @Override
    public boolean economyEnabled() {
        return this.economyEnabled;
    }
}

