/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.economy;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.economy.EconomyHook;
import org.black_ixx.playerpoints.PlayerPoints;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerPointsHook
implements EconomyHook {
    private UltraCosmetics ultraCosmetics;
    private PlayerPoints playerPoints;
    private boolean economyEnabled;

    public PlayerPointsHook(UltraCosmetics ultraCosmetics) {
        this.ultraCosmetics = ultraCosmetics;
        if (!ultraCosmetics.getServer().getPluginManager().isPluginEnabled("PlayerPoints")) {
            this.economyEnabled = false;
            return;
        }
        if (this.hookPlayerPoints()) {
            ultraCosmetics.getSmartLogger().write("");
            ultraCosmetics.getSmartLogger().write("Hooked into PlayerPoints for economy.");
            ultraCosmetics.getSmartLogger().write("");
            this.economyEnabled = true;
        } else {
            ultraCosmetics.getSmartLogger().write("");
            ultraCosmetics.getSmartLogger().write("Something happened while hooking into PlayerPoints for economy.");
            ultraCosmetics.getSmartLogger().write("");
            this.economyEnabled = false;
        }
    }

    private boolean hookPlayerPoints() {
        Plugin plugin = this.ultraCosmetics.getServer().getPluginManager().getPlugin("PlayerPoints");
        this.playerPoints = (PlayerPoints)plugin;
        return this.playerPoints != null;
    }

    @Override
    public void withdraw(Player player, int amount) {
        this.playerPoints.getAPI().take(player.getUniqueId(), amount);
    }

    @Override
    public void deposit(Player player, int amount) {
        this.playerPoints.getAPI().give(player.getUniqueId(), amount);
    }

    @Override
    public double balance(Player player) {
        return this.playerPoints.getAPI().look(player.getUniqueId());
    }

    @Override
    public String getName() {
        return "PlayerPoints";
    }

    @Override
    public boolean economyEnabled() {
        return this.economyEnabled;
    }
}

