/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.economy;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.economy.EconomyHook;
import be.isach.ultracosmetics.economy.PlayerPointsHook;
import be.isach.ultracosmetics.economy.VaultHook;
import org.bukkit.entity.Player;

public class EconomyHandler {
    private EconomyHook economyHook;
    private boolean usingEconomy;

    public EconomyHandler(UltraCosmetics ultraCosmetics, String economy) {
        if (economy == null || economy.equalsIgnoreCase("")) {
            ultraCosmetics.getSmartLogger().write("Economy not specified in the config, disabling economy features.");
            this.usingEconomy = false;
            return;
        }
        if (economy.equalsIgnoreCase("vault")) {
            this.economyHook = new VaultHook(ultraCosmetics);
            this.usingEconomy = true;
        } else if (economy.equalsIgnoreCase("playerpoints")) {
            this.economyHook = new PlayerPointsHook(ultraCosmetics);
            this.usingEconomy = true;
        } else {
            ultraCosmetics.getSmartLogger().write("Unknown economy: '" + economy + "'. Valid economies: Vault, PlayerPoints.");
            this.usingEconomy = false;
        }
    }

    public void withdraw(Player player, int amount) {
        this.economyHook.withdraw(player, amount);
    }

    public void deposit(Player player, int amount) {
        this.economyHook.deposit(player, amount);
    }

    public double balance(Player player) {
        return this.economyHook.balance(player);
    }

    public String getName() {
        return this.economyHook.getName();
    }

    public boolean isUsingEconomy() {
        return this.usingEconomy && this.economyHook.economyEnabled();
    }
}

