/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.type;

import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.suits.Suit;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.SuitCategory;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.util.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Color;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class SuitType
extends CosmeticType<Suit> {
    private static final List<SuitType> ENABLED = new ArrayList<SuitType>();
    private static final List<SuitType> VALUES = new ArrayList<SuitType>();
    private final ArmorSlot slot;
    private final SuitCategory category;

    public static List<SuitType> enabled() {
        return ENABLED;
    }

    public static List<SuitType> values() {
        return VALUES;
    }

    public static SuitType getSuitPart(String name, ArmorSlot slot) {
        for (SuitType suitType : VALUES) {
            if (!suitType.getConfigName().equalsIgnoreCase(name) || suitType.getSlot() != slot) continue;
            return suitType;
        }
        return null;
    }

    public static void checkEnabled() {
        ENABLED.addAll(SuitType.values().stream().filter(CosmeticType::isEnabled).collect(Collectors.toList()));
    }

    protected SuitType(XMaterial material, ArmorSlot slot, SuitCategory category) {
        super(Category.SUITS, category.getConfigName(), material, category.getSuitClass(), false);
        this.slot = slot;
        this.category = category;
        this.registerPermission();
        VALUES.add(this);
    }

    @Override
    public String getName() {
        return MessageManager.getMessage("Suits." + this.getConfigName() + "." + this.slot.toString().toLowerCase() + "-name");
    }

    @Override
    protected String getPermissionSuffix() {
        return this.category.getPermissionSuffix() + "." + this.slot.toString().toLowerCase();
    }

    public ArmorSlot getSlot() {
        return this.slot;
    }

    public SuitCategory getSuitCategory() {
        return this.category;
    }

    @Override
    public ItemStack getItemStack() {
        ItemStack is = super.getItemStack();
        Color color = null;
        if (this.category == SuitCategory.RAVE) {
            int r = MathUtils.random(255);
            int g = MathUtils.random(255);
            int b = MathUtils.random(255);
            color = Color.fromRGB((int)r, (int)g, (int)b);
        } else if (this.category == SuitCategory.SANTA) {
            color = Color.RED;
        } else if (this.category == SuitCategory.FROZEN && this.slot != ArmorSlot.HELMET) {
            color = Color.AQUA;
        }
        if (color != null) {
            LeatherArmorMeta meta = (LeatherArmorMeta)is.getItemMeta();
            meta.setColor(color);
            is.setItemMeta((ItemMeta)meta);
        }
        return is;
    }
}

