/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.type;

import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.suits.Suit;
import be.isach.ultracosmetics.cosmetics.suits.SuitAstronaut;
import be.isach.ultracosmetics.cosmetics.suits.SuitDiamond;
import be.isach.ultracosmetics.cosmetics.suits.SuitFrozen;
import be.isach.ultracosmetics.cosmetics.suits.SuitRave;
import be.isach.ultracosmetics.cosmetics.suits.SuitSanta;
import be.isach.ultracosmetics.cosmetics.type.SuitType;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum SuitCategory {
    RAVE("Rave", "rave", "&7&oSuch amazing colors!", XMaterial.LEATHER_HELMET, XMaterial.LEATHER_CHESTPLATE, XMaterial.LEATHER_LEGGINGS, XMaterial.LEATHER_BOOTS, SuitRave.class),
    ASTRONAUT("Astronaut", "astronaut", "&7&oHouston?", XMaterial.GLASS, XMaterial.GOLDEN_CHESTPLATE, XMaterial.GOLDEN_LEGGINGS, XMaterial.GOLDEN_BOOTS, SuitAstronaut.class),
    DIAMOND("Diamond", "diamond", "&7&oShow your Mining skills\n&7&owith this amazing outfit!", XMaterial.DIAMOND_HELMET, XMaterial.DIAMOND_CHESTPLATE, XMaterial.DIAMOND_LEGGINGS, XMaterial.DIAMOND_BOOTS, SuitDiamond.class),
    SANTA("Santa", "santa", "&7&oBecome Santa and deliver presents!", XMaterial.LEATHER_HELMET, XMaterial.LEATHER_CHESTPLATE, XMaterial.LEATHER_LEGGINGS, XMaterial.LEATHER_BOOTS, SuitSanta.class),
    FROZEN("Frozen", "frozen", "&7&oThis suit belongs to the\n&7&oLord of the Frozen Lands!", XMaterial.PACKED_ICE, XMaterial.LEATHER_CHESTPLATE, XMaterial.LEATHER_LEGGINGS, XMaterial.LEATHER_BOOTS, SuitFrozen.class);

    private final String configName;
    private final String permissionSuffix;
    private final String defaultDesc;
    private final SuitType helmet;
    private final SuitType chestplate;
    private final SuitType leggings;
    private final SuitType boots;
    private final Class<? extends Suit> clazz;

    private SuitCategory(String configName, String permissionSuffix, String defaultDesc, XMaterial helmet, XMaterial chestplate, XMaterial leggings, XMaterial boots, Class<? extends Suit> clazz) {
        this.configName = configName;
        this.permissionSuffix = permissionSuffix;
        this.defaultDesc = defaultDesc;
        this.clazz = clazz;
        this.helmet = new SuitType(helmet, ArmorSlot.HELMET, this);
        this.chestplate = new SuitType(chestplate, ArmorSlot.CHESTPLATE, this);
        this.leggings = new SuitType(leggings, ArmorSlot.LEGGINGS, this);
        this.boots = new SuitType(boots, ArmorSlot.BOOTS, this);
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getConfigPath() {
        return this.helmet.getConfigPath();
    }

    public String getPermissionSuffix() {
        return this.permissionSuffix;
    }

    public String getDefaultDesc() {
        return this.defaultDesc;
    }

    public Class<? extends Suit> getSuitClass() {
        return this.clazz;
    }

    public SuitType getHelmet() {
        return this.helmet;
    }

    public SuitType getChestplate() {
        return this.chestplate;
    }

    public SuitType getLeggings() {
        return this.leggings;
    }

    public SuitType getBoots() {
        return this.boots;
    }

    public boolean isEnabled() {
        return SettingsManager.getConfig().getBoolean("Suits." + this.configName + ".Enabled");
    }

    public SuitType getPiece(ArmorSlot slot) {
        switch (slot) {
            case HELMET: {
                return this.getHelmet();
            }
            default: {
                return this.getChestplate();
            }
            case LEGGINGS: {
                return this.getLeggings();
            }
            case BOOTS: 
        }
        return this.getBoots();
    }

    public List<SuitType> getPieces() {
        return Arrays.asList(this.getHelmet(), this.getChestplate(), this.getLeggings(), this.getBoots());
    }

    public static List<SuitCategory> enabled() {
        ArrayList<SuitCategory> enabled = new ArrayList<SuitCategory>();
        for (SuitCategory cat : SuitCategory.values()) {
            enabled.add(cat);
        }
        return enabled;
    }
}

