/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.type;

import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffect;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectAngelWings;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectBloodHelix;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectCrushedCandyCane;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectEnchanted;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectEnderAura;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectFireWaves;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectFlameFairy;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectFlameRings;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectFrostLord;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectFrozenWalk;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectGreenSparks;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectInLove;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectInferno;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectMagicalRods;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectMusic;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectRainCloud;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectSantaHat;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectSnowCloud;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffectSuperHero;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.util.Particles;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ParticleEffectType
extends CosmeticType<ParticleEffect> {
    private static final List<ParticleEffectType> ENABLED = new ArrayList<ParticleEffectType>();
    private static final List<ParticleEffectType> VALUES = new ArrayList<ParticleEffectType>();
    private final Particles effect;
    private final int repeatDelay;
    private final double particleMultiplier;

    public static List<ParticleEffectType> enabled() {
        return ENABLED;
    }

    public static List<ParticleEffectType> values() {
        return VALUES;
    }

    public static ParticleEffectType valueOf(String s) {
        for (ParticleEffectType particleEffectType : VALUES) {
            if (!particleEffectType.getConfigName().equalsIgnoreCase(s)) continue;
            return particleEffectType;
        }
        return null;
    }

    public static void checkEnabled() {
        ENABLED.addAll(ParticleEffectType.values().stream().filter(CosmeticType::isEnabled).collect(Collectors.toList()));
    }

    private ParticleEffectType(String configName, int repeatDelay, Particles effect, XMaterial material, Class<? extends ParticleEffect> clazz, boolean supportsParticleMultiplier) {
        super(Category.EFFECTS, configName, material, clazz);
        this.repeatDelay = repeatDelay;
        this.effect = effect;
        if (supportsParticleMultiplier) {
            String path = this.getCategory().getConfigPath() + "." + configName + ".Particle-Multiplier";
            if (!SettingsManager.getConfig().isDouble(path)) {
                this.particleMultiplier = 1.0;
                SettingsManager.getConfig().set(this.getCategory().getConfigPath() + "." + configName + ".Particle-Multiplier", 1.0, "A multiplier applied to the number", "of particles displayed. 1.0 is 100%");
            } else {
                this.particleMultiplier = SettingsManager.getConfig().getDouble(path);
            }
        } else {
            this.particleMultiplier = 1.0;
        }
        VALUES.add(this);
    }

    public Particles getEffect() {
        return this.effect;
    }

    public int getRepeatDelay() {
        return this.repeatDelay;
    }

    public double getParticleMultiplier() {
        return this.particleMultiplier;
    }

    public static void register() {
        new ParticleEffectType("SnowCloud", 1, Particles.SNOW_SHOVEL, XMaterial.SNOWBALL, ParticleEffectSnowCloud.class, true);
        new ParticleEffectType("BloodHelix", 1, Particles.REDSTONE, XMaterial.REDSTONE, ParticleEffectBloodHelix.class, true);
        new ParticleEffectType("FrostLord", 1, Particles.SNOW_SHOVEL, XMaterial.PACKED_ICE, ParticleEffectFrostLord.class, true);
        new ParticleEffectType("FlameRings", 1, Particles.FLAME, XMaterial.BLAZE_POWDER, ParticleEffectFlameRings.class, false);
        new ParticleEffectType("GreenSparks", 1, Particles.VILLAGER_HAPPY, XMaterial.EMERALD, ParticleEffectGreenSparks.class, false);
        new ParticleEffectType("FrozenWalk", 1, Particles.SNOW_SHOVEL, XMaterial.SNOWBALL, ParticleEffectFrozenWalk.class, false);
        new ParticleEffectType("Music", 4, Particles.FLAME, XMaterial.MUSIC_DISC_MALL, ParticleEffectMusic.class, true);
        new ParticleEffectType("Enchanted", 1, Particles.ENCHANTMENT_TABLE, XMaterial.BOOK, ParticleEffectEnchanted.class, true);
        new ParticleEffectType("Inferno", 1, Particles.FLAME, XMaterial.NETHER_WART, ParticleEffectInferno.class, true);
        new ParticleEffectType("AngelWings", 2, Particles.REDSTONE, XMaterial.FEATHER, ParticleEffectAngelWings.class, true);
        new ParticleEffectType("SuperHero", 2, Particles.REDSTONE, XMaterial.GLOWSTONE_DUST, ParticleEffectSuperHero.class, true);
        new ParticleEffectType("SantaHat", 2, Particles.REDSTONE, XMaterial.BEACON, ParticleEffectSantaHat.class, true);
        new ParticleEffectType("EnderAura", 1, Particles.PORTAL, XMaterial.ENDER_EYE, ParticleEffectEnderAura.class, true);
        new ParticleEffectType("FlameFairy", 1, Particles.FLAME, XMaterial.BLAZE_POWDER, ParticleEffectFlameFairy.class, false);
        new ParticleEffectType("RainCloud", 1, Particles.DRIP_WATER, XMaterial.LAPIS_LAZULI, ParticleEffectRainCloud.class, true);
        new ParticleEffectType("CrushedCandyCane", 1, Particles.ITEM_CRACK, XMaterial.WHITE_DYE, ParticleEffectCrushedCandyCane.class, true);
        new ParticleEffectType("InLove", 1, Particles.HEART, XMaterial.RED_DYE, ParticleEffectInLove.class, true);
        new ParticleEffectType("MagicalRods", 3, Particles.REDSTONE, XMaterial.BLAZE_ROD, ParticleEffectMagicalRods.class, true);
        new ParticleEffectType("FireWaves", 4, Particles.FLAME, XMaterial.GOLD_NUGGET, ParticleEffectFireWaves.class, true);
    }
}

