/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.type;

import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetAntiGravity;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetBatBlaster;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetBlackHole;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetBlizzardBlaster;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetChickenator;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetChristmasTree;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetColorBomb;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetDiscoBall;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetEtherealPearl;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetExplosiveSheep;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetFirework;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetFleshHook;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetFreezeCannon;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetFunGun;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetGhostParty;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetMelonThrower;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetPaintballGun;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetParachute;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetPartyPopper;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetPortalGun;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetQuakeGun;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetRocket;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetSmashDown;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetSnowball;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetTNT;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetThorHammer;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetTrampoline;
import be.isach.ultracosmetics.cosmetics.gadgets.GadgetTsunami;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GadgetType
extends CosmeticType<Gadget> {
    private static final List<GadgetType> ENABLED = new ArrayList<GadgetType>();
    private static final List<GadgetType> VALUES = new ArrayList<GadgetType>();
    private final double cooldown;
    private final int runTime;

    public static List<GadgetType> enabled() {
        return ENABLED;
    }

    public static List<GadgetType> values() {
        return VALUES;
    }

    public static GadgetType valueOf(String s) {
        return GadgetType.valueOf(s, false);
    }

    public static GadgetType valueOf(String s, boolean onlyEnabled) {
        Optional<GadgetType> bestMatchOptional;
        Optional<GadgetType> optionalType;
        String finalS = s.toLowerCase();
        Stream<GadgetType> stream = VALUES.stream().filter(gadgetType -> gadgetType.getConfigName().equalsIgnoreCase(finalS));
        if (onlyEnabled) {
            stream.filter(gadgetType -> gadgetType.isEnabled());
        }
        if ((optionalType = stream.findFirst()).isPresent()) {
            return optionalType.get();
        }
        stream = VALUES.stream().filter(gadgetType -> gadgetType.getConfigName().toLowerCase().startsWith(finalS));
        if (onlyEnabled) {
            stream.filter(gadgetType -> gadgetType.isEnabled());
        }
        if ((bestMatchOptional = stream.findFirst()).isPresent()) {
            return bestMatchOptional.get();
        }
        return null;
    }

    public static void checkEnabled() {
        ENABLED.addAll(GadgetType.values().stream().filter(CosmeticType::isEnabled).collect(Collectors.toList()));
    }

    private GadgetType(XMaterial material, double defaultCooldown, int runTime, String configName, Class<? extends Gadget> clazz) {
        super(Category.GADGETS, configName, material, clazz);
        if (!SettingsManager.getConfig().isDouble("Gadgets." + configName + ".Cooldown")) {
            this.cooldown = defaultCooldown;
            SettingsManager.getConfig().set("Gadgets." + configName + ".Cooldown", defaultCooldown);
        } else {
            this.cooldown = SettingsManager.getConfig().getDouble("Gadgets." + configName + ".Cooldown");
        }
        this.runTime = runTime;
        VALUES.add(this);
    }

    public boolean requiresAmmo() {
        return SettingsManager.getConfig().getBoolean("Gadgets." + this.getConfigName() + ".Ammo.Enabled");
    }

    public int getAmmoPrice() {
        return SettingsManager.getConfig().getInt("Gadgets." + this.getConfigName() + ".Ammo.Price");
    }

    public int getResultAmmoAmount() {
        return SettingsManager.getConfig().getInt("Gadgets." + this.getConfigName() + ".Ammo.Result-Amount");
    }

    public double getCountdown() {
        return Math.max(this.cooldown, (double)this.runTime);
    }

    public int getRunTime() {
        return this.runTime;
    }

    public static void register() {
        new GadgetType(XMaterial.IRON_HORSE_ARMOR, 8.0, 3, "BatBlaster", GadgetBatBlaster.class);
        new GadgetType(XMaterial.COOKED_CHICKEN, 6.0, 3, "Chickenator", GadgetChickenator.class);
        new GadgetType(XMaterial.BEACON, 45.0, 20, "DiscoBall", GadgetDiscoBall.class);
        new GadgetType(XMaterial.ENDER_PEARL, 2.0, 0, "EtherealPearl", GadgetEtherealPearl.class);
        new GadgetType(XMaterial.TRIPWIRE_HOOK, 5.0, 0, "FleshHook", GadgetFleshHook.class);
        new GadgetType(XMaterial.MELON, 2.0, 0, "MelonThrower", GadgetMelonThrower.class);
        new GadgetType(XMaterial.PACKED_ICE, 12.0, 2, "BlizzardBlaster", GadgetBlizzardBlaster.class);
        new GadgetType(XMaterial.COMPARATOR, 2.0, 0, "PortalGun", GadgetPortalGun.class);
        new GadgetType(XMaterial.SHEARS, 25.0, 11, "ExplosiveSheep", GadgetExplosiveSheep.class);
        new GadgetType(XMaterial.DIAMOND_HORSE_ARMOR, 0.5, 0, "PaintballGun", GadgetPaintballGun.class);
        new GadgetType(XMaterial.IRON_AXE, 8.0, 0, "ThorHammer", GadgetThorHammer.class);
        new GadgetType(XMaterial.ENDER_EYE, 30.0, 12, "AntiGravity", GadgetAntiGravity.class);
        new GadgetType(XMaterial.FIREWORK_STAR, 15.0, 0, "SmashDown", GadgetSmashDown.class);
        new GadgetType(XMaterial.FIREWORK_ROCKET, 60.0, 10, "Rocket", GadgetRocket.class);
        new GadgetType(XMaterial.WATER_BUCKET, 12.0, 2, "Tsunami", GadgetTsunami.class);
        new GadgetType(XMaterial.TNT, 10.0, 0, "TNT", GadgetTNT.class);
        new GadgetType(XMaterial.BLAZE_ROD, 4.0, 0, "FunGun", GadgetFunGun.class);
        new GadgetType(XMaterial.LEAD, 60.0, 7, "Parachute", GadgetParachute.class);
        new GadgetType(XMaterial.DIAMOND_HOE, 3.0, 0, "QuakeGun", GadgetQuakeGun.class);
        new GadgetType(XMaterial.SKELETON_SKULL, 45.0, 8, "GhostParty", GadgetGhostParty.class);
        new GadgetType(XMaterial.FIREWORK_ROCKET, 0.2, 0, "Firework", GadgetFirework.class);
        new GadgetType(XMaterial.FERN, 20.0, 10, "ChristmasTree", GadgetChristmasTree.class);
        new GadgetType(XMaterial.ICE, 8.0, 3, "FreezeCannon", GadgetFreezeCannon.class);
        new GadgetType(XMaterial.SNOWBALL, 0.5, 0, "Snowball", GadgetSnowball.class);
        new GadgetType(XMaterial.GOLDEN_CARROT, 2.0, 0, "PartyPopper", GadgetPartyPopper.class);
        new GadgetType(XMaterial.LIGHT_BLUE_WOOL, 25.0, 7, "ColorBomb", GadgetColorBomb.class);
        new GadgetType(XMaterial.BLUE_WOOL, 75.0, 12, "Trampoline", GadgetTrampoline.class);
        new GadgetType(XMaterial.BLACK_TERRACOTTA, 35.0, 8, "BlackHole", GadgetBlackHole.class);
    }
}

