/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.type;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.util.SmartLogger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;

public abstract class CosmeticType<T extends Cosmetic<?>> {
    private static final Permission ALL_PERMISSION = new Permission("ultracosmetics.allcosmetics");
    private static boolean PERMISSIONS_OK = true;
    private static YamlConfiguration customConfig = new YamlConfiguration();
    private final String configName;
    private final String description;
    private final Class<? extends T> clazz;
    private final Category category;
    private final XMaterial material;
    private Permission permission;

    protected static ConfigurationSection getCustomConfig(Category cat) {
        return customConfig.getConfigurationSection(cat.getConfigPath());
    }

    public CosmeticType(Category category, String configName, XMaterial material, Class<? extends T> clazz) {
        this(category, configName, material, clazz, true);
    }

    public CosmeticType(Category category, String configName, XMaterial material, Class<? extends T> clazz, boolean registerPerm) {
        this.configName = configName;
        this.clazz = clazz;
        this.category = category;
        this.material = material;
        this.description = MessageManager.getMessage(this.getCategory().getConfigPath() + "." + configName + ".Description");
        if (registerPerm) {
            this.registerPermission();
        }
    }

    public T equip(UltraPlayer player, UltraCosmetics ultraCosmetics) {
        Cosmetic cosmetic = null;
        try {
            cosmetic = (Cosmetic)((Object)this.getClazz().getDeclaredConstructor(UltraPlayer.class, this.getClass(), UltraCosmetics.class).newInstance(new Object[]{player, this, ultraCosmetics}));
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return null;
        }
        cosmetic.equip();
        return (T)((Object)cosmetic);
    }

    public boolean isEnabled() {
        return SettingsManager.getConfig().getBoolean(this.category.getConfigPath() + "." + this.configName + ".Enabled");
    }

    public String getName() {
        return MessageManager.getMessage(this.category.getConfigPath() + "." + this.configName + ".name");
    }

    public String getConfigName() {
        return this.configName;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public String getDescriptionAsString() {
        return this.description;
    }

    public Class<? extends T> getClazz() {
        return this.clazz;
    }

    public Category getCategory() {
        return this.category;
    }

    public XMaterial getMaterial() {
        return this.material;
    }

    public ItemStack getItemStack() {
        return this.material.parseItem();
    }

    public String getConfigPath() {
        return this.getCategory().getConfigPath() + "." + this.getConfigName();
    }

    public List<String> getDescription() {
        return Arrays.asList(ChatColor.translateAlternateColorCodes((char)'&', (String)this.getDescriptionAsString()).split("\n"));
    }

    public List<String> getDescriptionColored() {
        return Arrays.asList(this.getDescriptionAsString().split("\n"));
    }

    public boolean showsDescription() {
        return SettingsManager.getConfig().getBoolean(this.category.getConfigPath() + "." + this.getConfigName() + ".Show-Description");
    }

    public boolean canBeFound() {
        return this.getChestWeight() > 0;
    }

    public int getChestWeight() {
        return SettingsManager.getConfig().getInt(this.category.getConfigPath() + "." + this.getConfigName() + ".Treasure-Chest-Weight");
    }

    public String toString() {
        return this.getConfigName().toUpperCase();
    }

    protected void registerPermission() {
        this.permission = new Permission(this.category.getPermission() + "." + this.getPermissionSuffix());
        if (!PERMISSIONS_OK) {
            return;
        }
        Bukkit.getPluginManager().addPermission(this.permission);
        this.permission.addParent(ALL_PERMISSION, true);
    }

    protected String getPermissionSuffix() {
        return this.getConfigName().toLowerCase();
    }

    static {
        try {
            Bukkit.getPluginManager().addPermission(ALL_PERMISSION);
        }
        catch (IllegalArgumentException e) {
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.ERROR, "It seems like you are attempting to reload UltraCosmetics. This is not recommended. If you experience issues, please fully restart the server.");
            PERMISSIONS_OK = false;
        }
        try {
            File configFile = new File(UltraCosmeticsData.get().getPlugin().getDataFolder(), "custom_cosmetics.yml");
            if (!configFile.exists()) {
                UltraCosmeticsData.get().getPlugin().saveResource("custom_cosmetics.yml", false);
            }
            customConfig.load(configFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Failed to load custom cosmetics, they will be ignored.");
            e.printStackTrace();
        }
    }
}

