/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.suits;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.ArmorCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.type.SuitType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.ItemFactory;
import org.bukkit.plugin.Plugin;

public abstract class Suit
extends ArmorCosmetic<SuitType> {
    public Suit(UltraPlayer ultraPlayer, SuitType suitType, UltraCosmetics ultraCosmetics) {
        super(ultraPlayer, suitType, ultraCosmetics);
        this.setupItemStack();
    }

    @Override
    protected void scheduleTask() {
        this.runTaskTimerAsynchronously((Plugin)this.getUltraCosmetics(), 0L, 1L);
    }

    @Override
    public void run() {
        if (this.getPlayer() == null || this.getOwner().getSuit(this.getArmorSlot()) != this) {
            return;
        }
        ((Updatable)((Object)this)).onUpdate();
    }

    protected void setupItemStack() {
        this.itemStack = ItemFactory.create(((SuitType)this.getType()).getMaterial(), ((SuitType)this.getType()).getName(), "", MessageManager.getMessage("Suits.Suit-Part-Lore"));
    }

    @Override
    protected void unsetCosmetic() {
        this.getOwner().setCurrentSuitPart(this.getArmorSlot(), null);
    }

    @Override
    protected void unequipLikeCosmetics() {
        this.getOwner().removeSuit(this.getArmorSlot());
    }

    @Override
    protected void onEquip() {
    }

    @Override
    public ArmorSlot getArmorSlot() {
        return ((SuitType)this.cosmeticType).getSlot();
    }

    @Override
    public String getOccupiedSlotKey() {
        return "Suits.Must-Remove." + this.getArmorSlot().toString();
    }
}

