/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.pets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.EntityCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.pets.APlayerFollower;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.util.EntitySpawningManager;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.ServerVersion;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Difficulty;
import org.bukkit.Material;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class Pet
extends EntityCosmetic<PetType>
implements Updatable {
    protected List<Item> items = new ArrayList<Item>();
    protected ArmorStand armorStand;
    protected final APlayerFollower followTask;
    protected ItemStack dropItem;

    public Pet(UltraPlayer owner, PetType petType, UltraCosmetics ultraCosmetics, ItemStack dropItem) {
        super(owner, petType, ultraCosmetics);
        this.dropItem = dropItem;
        this.followTask = UltraCosmeticsData.get().getVersionManager().newPlayerFollower(this, this.getPlayer());
    }

    public Pet(UltraPlayer owner, PetType petType, UltraCosmetics ultraCosmetics, XMaterial dropItem) {
        this(owner, petType, ultraCosmetics, dropItem.parseItem());
    }

    public Pet(UltraPlayer owner, PetType petType, UltraCosmetics ultraCosmetics) {
        this(owner, petType, ultraCosmetics, petType.getItemStack());
    }

    @Override
    protected void onEquip() {
        EntitySpawningManager.setBypass(true);
        this.entity = this.spawnEntity();
        EntitySpawningManager.setBypass(false);
        UltraCosmeticsData.get().getVersionManager().getEntityUtil().clearPathfinders(this.entity);
        if (this.entity instanceof Ageable) {
            Ageable ageable = (Ageable)this.entity;
            if (SettingsManager.getConfig().getBoolean("Pets-Are-Babies")) {
                ageable.setBaby();
            } else {
                ageable.setAdult();
            }
            ageable.setAgeLock(true);
        }
        if (this.entity instanceof Tameable) {
            ((Tameable)this.entity).setTamed(true);
        }
        if (this.isCustomEntity() || UltraCosmeticsData.get().getServerVersion() == ServerVersion.v1_8) {
            this.armorStand = (ArmorStand)this.entity.getWorld().spawnEntity(this.entity.getLocation(), EntityType.ARMOR_STAND);
            this.armorStand.setVisible(false);
            this.armorStand.setSmall(true);
            this.armorStand.setMarker(true);
            this.armorStand.setCustomNameVisible(true);
            FixedMetadataValue metadataValue = new FixedMetadataValue((Plugin)this.getUltraCosmetics(), (Object)"C_AD_ArmorStand");
            this.armorStand.setMetadata("C_AD_ArmorStand", (MetadataValue)metadataValue);
            this.entity.setPassenger((Entity)this.armorStand);
        } else {
            this.getEntity().setCustomNameVisible(true);
        }
        this.updateName();
        ((LivingEntity)this.entity).setRemoveWhenFarAway(false);
        if (SettingsManager.getConfig().getBoolean("Pets-Are-Silent", false)) {
            UltraCosmeticsData.get().getVersionManager().getAncientUtil().setSilent(this.entity, true);
        }
        this.entity.setMetadata("Pet", (MetadataValue)new FixedMetadataValue((Plugin)this.getUltraCosmetics(), (Object)"UltraCosmetics"));
        this.setupEntity();
    }

    @Override
    protected void scheduleTask() {
        this.runTaskTimer((Plugin)this.getUltraCosmetics(), 0L, 3L);
    }

    @Override
    public boolean tryEquip() {
        if (((PetType)this.getType()).isMonster() && this.getPlayer().getWorld().getDifficulty() == Difficulty.PEACEFUL) {
            this.getOwner().sendMessage(MessageManager.getMessage("Mounts.Cant-Spawn"));
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        if (this.entity != null && !this.entity.isValid()) {
            this.clear();
            return;
        }
        if (this.getOwner().isOnline() && this.getOwner().getCurrentPet() == this) {
            this.onUpdate();
            this.followTask.run();
        } else {
            this.clear();
        }
    }

    @Override
    protected void onClear() {
        if (this.armorStand != null) {
            this.armorStand.remove();
        }
        this.removeEntity();
        this.items.stream().filter(Entity::isValid).forEach(Entity::remove);
        this.items.clear();
    }

    public APlayerFollower getFollowTask() {
        return this.followTask;
    }

    public ArmorStand getArmorStand() {
        return this.armorStand;
    }

    public boolean hasArmorStand() {
        return this.armorStand != null;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void updateName() {
        Object rename = this.armorStand == null ? this.entity : this.armorStand;
        if (this.getOwner().getPetName((PetType)this.getType()) != null) {
            rename.setCustomName(this.getOwner().getPetName((PetType)this.getType()));
        } else {
            rename.setCustomName(((PetType)this.getType()).getEntityName(this.getPlayer()));
        }
    }

    protected Entity getNamedEntity() {
        return this.entity;
    }

    @Override
    public void onUpdate() {
        if (SettingsManager.getConfig().getBoolean("Pets-Drop-Items")) {
            this.dropItem();
        }
    }

    public void dropItem() {
        Vector velocity = new Vector(RANDOM.nextDouble() - 0.5, RANDOM.nextDouble() / 2.0 + 0.3, RANDOM.nextDouble() - 0.5).multiply(0.4);
        Item drop = ItemFactory.spawnUnpickableItem(this.dropItem, ((LivingEntity)this.entity).getEyeLocation(), velocity);
        this.items.add(drop);
        Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), () -> {
            drop.remove();
            this.items.remove(drop);
        }, 5L);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntity() == this.getEntity()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (event.getPlayer() == this.getPlayer()) {
            this.getEntity().teleport((Entity)this.getPlayer());
        }
    }

    @EventHandler
    public void onClick(PlayerInteractEntityEvent event) {
        if (event.getRightClicked() == this.entity) {
            event.setCancelled(true);
        }
    }

    @Override
    protected String filterPlaceholders(String message) {
        String filtered = super.filterPlaceholders(message);
        String name = this.getOwner().getPetName((PetType)this.getType());
        if (name != null) {
            filtered = filtered + " " + ChatColor.GRAY + "(" + name + ChatColor.GRAY + ")";
        }
        return filtered;
    }

    public boolean isCustomEntity() {
        return false;
    }

    public boolean customize(String customization) {
        return false;
    }

    protected ItemStack parseCustomItem(String customization) {
        String[] parts = customization.split(":", 2);
        Material mat = Material.matchMaterial((String)parts[0]);
        if (mat == null) {
            return null;
        }
        ItemStack stack = new ItemStack(mat);
        if (parts.length > 1) {
            int model;
            try {
                model = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            ItemMeta meta = stack.getItemMeta();
            meta.setCustomModelData(Integer.valueOf(model));
            stack.setItemMeta(meta);
        }
        return stack;
    }
}

