/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.particleeffects;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffect;
import be.isach.ultracosmetics.cosmetics.type.ParticleEffectType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.Particles;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class ParticleEffectMagicalRods
extends ParticleEffect {
    private static final List<Color> COLORS = new ArrayList<Color>();
    private final double RADIUS = 1.1;
    private final double ROD_HEIGHT = 1.0;
    private final int TOTAL_COLUMNS = 8;
    private final double BASE_HEIGHT = 0.4;
    private final double MIN_HEIGHT = 0.0;
    private final double MAX_HEIGHT = 0.6;
    private final double HEIGHT_STEP = 0.03;
    private final double MAX_HEIGHT_DIFF = 0.5;
    private final double HEIGHT_DIFF_STEP = 0.04;
    private boolean heightDirectionUp;
    private boolean hoveringDirectionUp;
    private double height = 0.0;
    private double angle = 0.0;
    private double heightDiffFactor = 0.5;

    public ParticleEffectMagicalRods(UltraPlayer owner, ParticleEffectType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void onUpdate() {
        if (this.heightDirectionUp) {
            if (this.height < 0.6) {
                this.height += 0.03;
            } else {
                this.heightDirectionUp = false;
            }
        } else if (this.height > 0.0) {
            this.height -= 0.03;
        } else {
            this.heightDirectionUp = true;
        }
        if (this.hoveringDirectionUp) {
            if (this.heightDiffFactor < 0.5) {
                this.heightDiffFactor += 0.04;
            } else {
                this.hoveringDirectionUp = false;
            }
        } else if (this.heightDiffFactor > -0.5) {
            this.heightDiffFactor -= 0.04;
        } else {
            this.hoveringDirectionUp = true;
        }
        this.drawColumns(this.height, this.angle);
        this.angle += Math.toRadians(1.0);
    }

    private void drawColumns(Double height, double suppAngle) {
        int cycles = 8 / COLORS.size();
        double workingSpace = Math.PI * 2 / (double)cycles;
        double startAngle = 0.0;
        Vector v = new Vector(0, 0, 0);
        for (int i = 0; i < cycles; ++i) {
            double angleStep = startAngle;
            for (int j = 0; j < COLORS.size(); ++j) {
                v.setX(Math.cos(angleStep + suppAngle) * 1.1);
                v.setZ(Math.sin(angleStep + suppAngle) * 1.1);
                v.setY(0.4 + Math.sin(angleStep * 3.0) * this.heightDiffFactor);
                Location loc = this.getPlayer().getLocation().add(v);
                Particles.REDSTONE.drawParticleLine(loc, loc.clone().add(0.0, 1.0, 0.0), this.getModifiedAmount(5), COLORS.get(j));
                angleStep += workingSpace / (double)COLORS.size();
                height = height + (i >= 3 && i <= 5 ? this.heightDiffFactor : -this.heightDiffFactor);
            }
            startAngle += workingSpace;
        }
    }

    static {
        COLORS.add(Color.GREEN);
        COLORS.add(new Color(0, 128, 0));
        COLORS.add(new Color(0, 74, 0));
        COLORS.add(new Color(0, 36, 0));
    }
}

