/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.particleeffects;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffect;
import be.isach.ultracosmetics.cosmetics.type.ParticleEffectType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.util.Particles;
import be.isach.ultracosmetics.version.VersionManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.util.Vector;

public class ParticleEffectFrozenWalk
extends ParticleEffect {
    public ParticleEffectFrozenWalk(UltraPlayer owner, ParticleEffectType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void onUpdate() {
        Vector vectorLeft = ParticleEffectFrozenWalk.getLeftVector(this.getPlayer().getLocation()).normalize().multiply(0.15);
        Vector vectorRight = ParticleEffectFrozenWalk.getRightVector(this.getPlayer().getLocation()).normalize().multiply(0.15);
        Location locationLeft = this.getPlayer().getLocation().add(vectorLeft);
        Location locationRight = this.getPlayer().getLocation().add(vectorRight);
        locationLeft.setY(this.getPlayer().getLocation().getY());
        locationRight.setY(this.getPlayer().getLocation().getY());
        if (VersionManager.IS_VERSION_1_13) {
            locationLeft.getWorld().spawnParticle(Particle.ITEM_CRACK, locationLeft, 0, 0.0, 0.0, 0.0, 0.0, (Object)XMaterial.SNOW.parseItem());
            locationLeft.getWorld().spawnParticle(Particle.ITEM_CRACK, locationRight, 0, 0.0, 0.0, 0.0, 0.0, (Object)XMaterial.SNOW.parseItem());
        } else {
            Particles.ITEM_CRACK.display((Particles.ParticleData)new Particles.ItemData(Material.SNOW, 0), 0.0f, 0.0f, 0.0f, 0.0f, 0, locationLeft, 32.0);
            Particles.ITEM_CRACK.display((Particles.ParticleData)new Particles.ItemData(Material.SNOW, 0), 0.0f, 0.0f, 0.0f, 0.0f, 0, locationRight, 32.0);
        }
    }

    public static Vector getLeftVector(Location loc) {
        float newX = (float)(loc.getX() + 1.0 * Math.cos(Math.toRadians(loc.getYaw() + 0.0f)));
        float newZ = (float)(loc.getZ() + 1.0 * Math.sin(Math.toRadians(loc.getYaw() + 0.0f)));
        return new Vector((double)newX - loc.getX(), 0.0, (double)newZ - loc.getZ());
    }

    public static Vector getRightVector(Location loc) {
        float newX = (float)(loc.getX() + -1.0 * Math.cos(Math.toRadians(loc.getYaw() + 0.0f)));
        float newZ = (float)(loc.getZ() + -1.0 * Math.sin(Math.toRadians(loc.getYaw() + 0.0f)));
        return new Vector((double)newX - loc.getX(), 0.0, (double)newZ - loc.getZ());
    }
}

