/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.particleeffects;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.particleeffects.ParticleEffect;
import be.isach.ultracosmetics.cosmetics.type.ParticleEffectType;
import be.isach.ultracosmetics.player.UltraPlayer;
import org.bukkit.util.Vector;

public class ParticleEffectFireWaves
extends ParticleEffect {
    private final double RADIUS = 1.1;
    private final int U_PER_WAVE = 4;
    private final double MAX_HEIGHT_DIFF = 0.5;
    private final double HEIGHT_DIFF_STEP = 0.05;
    private boolean heightFactorDir;
    private double heightFactor = 0.5;

    public ParticleEffectFireWaves(UltraPlayer owner, ParticleEffectType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void onUpdate() {
        if (this.heightFactorDir) {
            if (this.heightFactor < 0.5) {
                this.heightFactor += 0.05;
            } else {
                this.heightFactorDir = false;
            }
        } else if (this.heightFactor > -0.5) {
            this.heightFactor -= 0.05;
        } else {
            this.heightFactorDir = true;
        }
        this.drawWave();
    }

    private void drawWave() {
        Vector v = new Vector(0, 0, 0);
        for (double angle = 0.0; angle <= Math.PI * 2; angle += 0.13962634015954636 / ((ParticleEffectType)this.getType()).getParticleMultiplier()) {
            v.setX(Math.cos(angle) * 1.1);
            v.setZ(Math.sin(angle) * 1.1);
            v.setY(0.5 + Math.sin(angle * 4.0) * this.heightFactor);
            ((ParticleEffectType)this.getType()).getEffect().display(this.getPlayer().getLocation().add(v));
            ((ParticleEffectType)this.getType()).getEffect().display(this.getPlayer().getLocation().add(v).add(0.0, 1.0, 0.0));
        }
    }
}

