/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.mounts.pretendhorse;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.mounts.MountHorse;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.Particles;
import be.isach.ultracosmetics.util.PlayerUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class MountRudolph
extends MountHorse {
    private ArmorStand left;
    private ArmorStand right;

    public MountRudolph(UltraPlayer owner, MountType type, UltraCosmetics ultraCosmetics) {
        super(owner, ultraCosmetics, type);
    }

    @Override
    public void setupEntity() {
        super.setupEntity();
        this.left = this.spawnArmorStand(false);
        this.right = this.spawnArmorStand(true);
        this.moveAntlers();
    }

    private ArmorStand spawnArmorStand(boolean right) {
        ArmorStand armorStand = (ArmorStand)this.getEntity().getWorld().spawn(this.getEyeLocation(), ArmorStand.class);
        armorStand.setBasePlate(false);
        armorStand.setGravity(false);
        armorStand.setArms(true);
        armorStand.setVisible(false);
        if (!right) {
            armorStand.setRightArmPose(new EulerAngle(Math.PI, 0.7853981633974483, -0.7853981633974483));
        } else {
            armorStand.setRightArmPose(new EulerAngle(Math.PI, -0.7853981633974483, 0.7853981633974483));
        }
        armorStand.setItemInHand(new ItemStack(Material.DEAD_BUSH));
        armorStand.setMetadata("C_AD_ArmorStand", (MetadataValue)new FixedMetadataValue((Plugin)this.getUltraCosmetics(), (Object)this.getPlayer().getUniqueId().toString()));
        this.getUltraCosmetics().getArmorStandManager().makeUcStand(armorStand);
        return armorStand;
    }

    @Override
    public void onUpdate() {
        if (this.left != null && this.right != null) {
            this.moveAntlers();
        }
    }

    private void moveAntlers() {
        Location location = this.getEyeLocation();
        Vector vectorLeft = MountRudolph.getLeftVector(location).multiply(0.5).multiply(1.6);
        Vector rightVector = MountRudolph.getRightVector(location).multiply(0.5).multiply(0.4);
        Vector playerVector = PlayerUtils.getHorizontalDirection(this.getPlayer(), 0.75);
        location.add(vectorLeft).add(playerVector).add(0.0, -1.7, 0.0);
        this.left.teleport(location);
        location.subtract(vectorLeft).add(rightVector);
        this.right.teleport(location);
        location.subtract(rightVector).subtract(playerVector).subtract(0.0, -1.5, 0.0);
        double y = location.getY();
        location.add(location.getDirection().multiply(1.15));
        location.setY(y - 0.073);
        Particles.REDSTONE.display(255, 0, 0, location);
        new Thread(() -> {
            for (Player player : this.getPlayer().getWorld().getPlayers()) {
                UltraCosmeticsData.get().getVersionManager().getEntityUtil().sendTeleportPacket(player, (Entity)this.right);
                UltraCosmeticsData.get().getVersionManager().getEntityUtil().sendTeleportPacket(player, (Entity)this.left);
            }
        }).start();
    }

    @Override
    public void onClear() {
        super.onClear();
        if (this.left != null) {
            this.left.remove();
        }
        if (this.right != null) {
            this.right.remove();
        }
    }

    public static Vector getLeftVector(Location loc) {
        float newX = (float)(loc.getX() + 1.0 * Math.cos(Math.toRadians(loc.getYaw() + 0.0f)));
        float newZ = (float)(loc.getZ() + 1.0 * Math.sin(Math.toRadians(loc.getYaw() + 0.0f)));
        return new Vector((double)newX - loc.getX(), 0.0, (double)newZ - loc.getZ());
    }

    public static Vector getRightVector(Location loc) {
        float newX = (float)(loc.getX() + -1.0 * Math.cos(Math.toRadians(loc.getYaw() + 0.0f)));
        float newZ = (float)(loc.getZ() + -1.0 * Math.sin(Math.toRadians(loc.getYaw() + 0.0f)));
        return new Vector((double)newX - loc.getX(), 0.0, (double)newZ - loc.getZ());
    }

    @Override
    protected Horse.Variant getVariant() {
        return Horse.Variant.MULE;
    }

    @Override
    protected Horse.Color getColor() {
        return null;
    }

    private Location getEyeLocation() {
        return ((Horse)this.entity).getEyeLocation();
    }
}

