/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.mounts;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.mounts.Mount;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.player.UltraPlayer;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class MountMoltenSnake
extends Mount {
    private List<Entity> entities = new ArrayList<Entity>();
    private Location lastLocation;
    private float lastYaw;
    private float lastPitch;

    public MountMoltenSnake(UltraPlayer owner, MountType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void setupEntity() {
        ((MagmaCube)this.entity).setSize(2);
        this.entities.add(this.entity);
        this.summonTailPart(25);
    }

    @Override
    public void onUpdate() {
        if (this.getPlayer() == null) {
            return;
        }
        Vector playerVector = this.getPlayer().getLocation().getDirection().multiply(0.7);
        for (int i = 0; i < this.entities.size(); ++i) {
            Entity entity = this.entities.get(i);
            Location loc = entity.getLocation();
            if (i == 0) {
                entity.setVelocity(playerVector);
                entity.teleport(loc.clone().add(0.0, -1.3, 0.0));
            } else {
                if (i != 1) {
                    entity.teleport(this.lastLocation);
                } else {
                    entity.teleport(this.lastLocation.clone().add(0.0, -1.3, 0.0));
                    this.setHelmet((ArmorStand)entity, null);
                }
                ArmorStand as = (ArmorStand)entity;
                as.setHeadPose(new EulerAngle(Math.toRadians(this.lastPitch), Math.toRadians(this.lastYaw), 0.0));
            }
            this.lastLocation = loc;
            this.lastYaw = this.getPlayer().getLocation().getYaw();
            this.lastPitch = this.getPlayer().getLocation().getPitch();
        }
    }

    private void summonTailPart(int j) {
        Location location = this.getPlayer().getLocation();
        Vector v = this.getPlayer().getLocation().getDirection().multiply(-0.25);
        for (int i = 0; i < j; ++i) {
            ArmorStand armorStand = (ArmorStand)this.getPlayer().getWorld().spawn(location.add(v), ArmorStand.class);
            this.entities.add((Entity)armorStand);
            armorStand.setVisible(false);
            armorStand.setGravity(false);
            this.setHelmet(armorStand, new ItemStack(Material.NETHERRACK));
            armorStand.setMetadata("NO_INTER", (MetadataValue)new FixedMetadataValue((Plugin)this.getUltraCosmetics(), (Object)""));
        }
    }

    private void setHelmet(ArmorStand stand, ItemStack itemStack) {
        stand.setHelmet(itemStack);
    }

    @Override
    public void onClear() {
        super.onClear();
        for (Entity entity : this.entities) {
            entity.remove();
        }
        this.entities.clear();
    }
}

