/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.mounts;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.mounts.Mount;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.run.FallDamageManager;
import org.bukkit.entity.EnderDragonPart;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.util.Vector;

public class MountDragon
extends Mount {
    public MountDragon(UltraPlayer owner, MountType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void onUpdate() {
        if (SettingsManager.getConfig().getBoolean("Mounts." + ((MountType)this.getType()).getConfigName() + ".Stationary")) {
            return;
        }
        Vector vector = this.getPlayer().getLocation().toVector();
        double rotX = this.getPlayer().getLocation().getYaw();
        double rotY = this.getPlayer().getLocation().getPitch();
        vector.setY(-Math.sin(Math.toRadians(rotY)));
        double h = Math.cos(Math.toRadians(rotY));
        vector.setX(-h * Math.sin(Math.toRadians(rotX)));
        vector.setZ(h * Math.cos(Math.toRadians(rotX)));
        UltraCosmeticsData.get().getVersionManager().getEntityUtil().moveDragon(this.getPlayer(), vector, this.entity);
    }

    @Override
    public void onClear() {
        super.onClear();
        if (!this.getPlayer().isOnGround()) {
            FallDamageManager.addNoFall((Entity)this.getPlayer());
        }
    }

    @EventHandler
    public void stopDragonDamage(EntityExplodeEvent event) {
        Entity e = event.getEntity();
        if (e instanceof EnderDragonPart) {
            e = ((EnderDragonPart)e).getParent();
        }
        if (e == this.entity) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Entity e = event.getDamager();
        if (e instanceof EnderDragonPart) {
            e = ((EnderDragonPart)e).getParent();
        }
        if (e == this.entity) {
            event.setCancelled(true);
        }
    }
}

