/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.mounts;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.EntityCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.run.MountRegionChecker;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.util.Area;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.EntitySpawningManager;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public abstract class Mount
extends EntityCosmetic<MountType>
implements Updatable {
    private BukkitTask mountRegionTask = null;
    protected boolean beingRemoved = false;
    protected final boolean placesBlocks = ((MountType)this.getType()).doesPlaceBlocks();

    public Mount(UltraPlayer ultraPlayer, MountType type, UltraCosmetics ultraCosmetics) {
        super(ultraPlayer, type, ultraCosmetics);
    }

    @Override
    public void onEquip() {
        EntitySpawningManager.setBypass(true);
        this.entity = this.spawnEntity();
        EntitySpawningManager.setBypass(false);
        if (this.entity instanceof LivingEntity) {
            UltraCosmeticsData.get().getVersionManager().getAncientUtil().setSpeed((LivingEntity)this.entity, ((MountType)this.getType()).getMovementSpeed());
            if (this.entity instanceof Ageable) {
                ((Ageable)this.entity).setAdult();
            } else if (this.entity instanceof Slime) {
                ((Slime)this.entity).setSize(3);
            }
        }
        this.entity.setCustomNameVisible(true);
        this.entity.setCustomName(((MountType)this.getType()).getName(this.getPlayer()));
        this.entity.setPassenger((Entity)this.getPlayer());
        this.entity.setMetadata("Mount", (MetadataValue)new FixedMetadataValue((Plugin)UltraCosmeticsData.get().getPlugin(), (Object)"UltraCosmetics"));
        this.setupEntity();
        if (!this.getUltraCosmetics().worldGuardHooked()) {
            return;
        }
        if (this.isHorse(this.entity.getType())) {
            return;
        }
        this.mountRegionTask = new MountRegionChecker(this.getOwner(), this.getUltraCosmetics()).runTaskTimer((Plugin)this.getUltraCosmetics(), 0L, 1L);
    }

    @Override
    protected void scheduleTask() {
        this.runTaskTimer((Plugin)this.getUltraCosmetics(), 0L, ((MountType)this.getType()).getRepeatDelay());
    }

    @Override
    protected boolean tryEquip() {
        if (((MountType)this.getType()).isMonster() && this.getPlayer().getWorld().getDifficulty() == Difficulty.PEACEFUL) {
            this.getOwner().sendMessage(MessageManager.getMessage("Mounts.Cant-Spawn"));
            return false;
        }
        Location center = this.getPlayer().getLocation();
        center.setY(Math.ceil(center.getY()));
        Area area = new Area(center, 1, 1);
        if (!area.isTransparent()) {
            this.getOwner().sendMessage(MessageManager.getMessage("Mounts.Not-Enough-Room"));
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        if (this.entity.getPassenger() != this.getPlayer() && this.entity.getTicksLived() > 10) {
            this.clear();
            return;
        }
        if (!this.entity.isValid()) {
            this.cancel();
            return;
        }
        if (this.entity.getLocation().getY() <= (double)(UltraCosmeticsData.get().getVersionManager().getWorldMinHeight(this.entity.getWorld()) - 15)) {
            this.clear();
            return;
        }
        if (this.getOwner() != null && Bukkit.getPlayer((UUID)this.getOwnerUniqueId()) != null && this.getOwner().getCurrentMount() != null && this.getOwner().getCurrentMount().getType() == this.getType()) {
            this.onUpdate();
        } else {
            this.cancel();
        }
    }

    @Override
    protected void onClear() {
        if (this.entity != null) {
            this.entity.remove();
        }
        if (this.mountRegionTask != null) {
            this.mountRegionTask.cancel();
        }
    }

    @EventHandler
    public void onPlayerToggleSneakEvent(VehicleExitEvent event) {
        if (event.getVehicle().getType() == EntityType.BOAT || event.getVehicle().getType().toString().contains("MINECART")) {
            return;
        }
        String name = ((MountType)this.getType()).getName(this.getPlayer());
        if (!this.beingRemoved && name != null && this.getOwner() != null && this.getPlayer() != null && this.getOwner() != null && event.getVehicle() != null && event.getExited() != null && event.getVehicle().getCustomName() != null && event.getVehicle().getCustomName().equals(name) && event.getExited() == this.getPlayer()) {
            this.beingRemoved = true;
            this.clear();
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntity() == this.getEntity()) {
            event.setCancelled(true);
        }
        if (event.getEntity() == this.getPlayer() && this.getOwner().getCurrentMount() != null && this.getOwner().getCurrentMount().getType() == this.getType() && !this.getUltraCosmetics().getConfig().getBoolean("allow-damage-to-players-on-mounts")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getEntity() == this.getEntity() || event.getDamager() == this.getEntity()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void teleportEvent(PlayerTeleportEvent event) {
        if (this.getOwner() == null || this.getPlayer() == null || this.getOwner().getCurrentMount() != this || event.getPlayer() != this.getPlayer() || event.getFrom().getBlockX() != event.getTo().getBlockX() || event.getFrom().getBlockY() != event.getTo().getBlockY() || event.getFrom().getBlockZ() != event.getTo().getBlockZ() || !event.getFrom().getWorld().getName().equalsIgnoreCase(event.getTo().getWorld().getName())) {
            // empty if block
        }
    }

    @EventHandler
    public void openInv(InventoryOpenEvent event) {
        if (!this.isHorse(((MountType)this.getType()).getEntityType())) {
            return;
        }
        if (this.getOwner() != null && this.getPlayer() != null && event.getPlayer() == this.getPlayer() && event.getInventory().equals(((InventoryHolder)this.entity).getInventory())) {
            event.setCancelled(true);
        }
    }

    public void setBeingRemoved(boolean beingRemoved) {
        this.beingRemoved = beingRemoved;
    }

    private boolean isHorse(EntityType type) {
        return UltraCosmeticsData.get().getVersionManager().getMounts().isAbstractHorse(type);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.placesBlocks && event.getPlayer() == this.getPlayer() && this.getOwner().getCurrentMount() == this && SettingsManager.getConfig().getBoolean("Mounts-Block-Trails")) {
            List<XMaterial> mats = ItemFactory.getXMaterialListFromConfig("Mounts." + ((MountType)this.getType()).getConfigName() + ".Blocks-To-Place");
            if (mats.size() == 0) {
                return;
            }
            HashMap<Block, XMaterial> updates = new HashMap<Block, XMaterial>();
            for (Block b : BlockUtils.getBlocksInRadius(event.getPlayer().getLocation(), 3, false)) {
                if (b.getLocation().getBlockY() != event.getPlayer().getLocation().getBlockY() - 1) continue;
                XMaterial mat = mats.get(RANDOM.nextInt(mats.size()));
                updates.put(b, mat);
            }
            BlockUtils.setToRestore(updates, 20);
        }
    }
}

