/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.morphs;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.morphs.Morph;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.MathUtils;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;

public class MorphWitherSkeleton
extends Morph
implements PlayerAffectingCosmetic {
    private boolean inCooldown;

    public MorphWitherSkeleton(UltraPlayer owner, MorphType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSneak(PlayerToggleSneakEvent event) {
        if (event.getPlayer() == this.getPlayer() && !this.inCooldown) {
            this.inCooldown = true;
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.getUltraCosmetics(), () -> {
                this.inCooldown = false;
            }, 200L);
            for (Entity ent : this.getPlayer().getNearbyEntities(3.0, 3.0, 3.0)) {
                if (!this.canAffect(ent)) continue;
                MathUtils.applyVelocity(ent, ent.getLocation().toVector().subtract(this.getPlayer().getLocation().toVector()).setY(1));
            }
            ArrayList<Item> items = new ArrayList<Item>();
            for (int i = 0; i < 20; ++i) {
                Location itemLoc = this.getPlayer().getLocation().add(Math.random() * 5.0 - 2.5, Math.random() * 3.0, Math.random() * 5.0 - 2.5);
                items.add(ItemFactory.spawnUnpickableItem(XMaterial.BONE.parseItem(), itemLoc, MathUtils.getRandomVector()));
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), () -> {
                for (Entity bone : items) {
                    bone.remove();
                }
                items.clear();
            }, 50L);
            XSound.ENTITY_SKELETON_HURT.play((Entity)this.getPlayer(), 0.4f, (float)Math.random() + 1.0f);
        }
    }
}

