/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.morphs;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.morphs.Morph;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.util.MathUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MorphPig
extends Morph
implements PlayerAffectingCosmetic,
Updatable {
    private boolean cooldown = false;

    public MorphPig(UltraPlayer owner, MorphType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void onUpdate() {
        if (this.cooldown || !this.isAffectingPlayersEnabled()) {
            return;
        }
        for (Entity ent : this.getPlayer().getNearbyEntities(0.2, 0.2, 0.2)) {
            if (!this.canAffect(ent)) continue;
            this.cooldown = true;
            Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), () -> {
                this.cooldown = false;
            }, 20L);
            XSound.ENTITY_PIG_AMBIENT.play((Entity)this.getPlayer(), 0.2f, 1.5f);
            Vector v = new Vector(0.0, 0.6, 0.0);
            Vector vEnt = ent.getLocation().toVector().subtract(this.getPlayer().getLocation().toVector()).add(v);
            Vector vPig = this.getPlayer().getLocation().toVector().subtract(ent.getLocation().toVector()).add(v);
            vEnt.setY(0.5);
            vPig.setY(0.5);
            MathUtils.applyVelocity(ent, vEnt.multiply(0.75));
            MathUtils.applyVelocity((Entity)this.getPlayer(), vPig.multiply(0.75));
        }
    }
}

