/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.morphs;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.morphs.Morph;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.player.UltraPlayer;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Firework;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;

public class MorphEnderman
extends Morph {
    private boolean cooldown;

    public MorphEnderman(UltraPlayer owner, MorphType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onEquip() {
        super.onEquip();
        this.getPlayer().setAllowFlight(true);
    }

    @EventHandler
    public void onPlayerToggleFligh(PlayerToggleFlightEvent event) {
        if (event.getPlayer() == this.getPlayer() && event.getPlayer().getGameMode() != GameMode.CREATIVE && !event.getPlayer().isFlying()) {
            if (this.cooldown) {
                event.getPlayer().setFlying(false);
                event.setCancelled(true);
                return;
            }
            this.cooldown = true;
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.getUltraCosmetics(), () -> {
                this.cooldown = false;
            }, 70L);
            Block b = event.getPlayer().getTargetBlock(null, 17);
            Location loc = b.getLocation();
            loc.setPitch(event.getPlayer().getLocation().getPitch());
            loc.setYaw(event.getPlayer().getLocation().getYaw());
            event.getPlayer().teleport(loc);
            this.spawnRandomFirework(b.getLocation().add(0.5, 0.0, 0.5));
            event.getPlayer().setFlying(false);
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.getEntity() == this.getPlayer() && this.getOwner().getCurrentMorph() == this) {
            event.setCancelled(true);
        }
    }

    public static FireworkEffect getRandomFireworkEffect() {
        FireworkEffect.Builder builder = FireworkEffect.builder();
        return builder.flicker(false).trail(false).with(FireworkEffect.Type.BALL_LARGE).withColor(Color.fromRGB((int)0, (int)0, (int)0)).withFade(Color.fromRGB((int)0, (int)0, (int)0)).build();
    }

    public void spawnRandomFirework(Location location) {
        ArrayList<Firework> fireworks = new ArrayList<Firework>();
        for (int i = 0; i < 4; ++i) {
            Firework f = (Firework)this.getPlayer().getWorld().spawn(location, Firework.class);
            FireworkMeta fm = f.getFireworkMeta();
            fm.addEffect(MorphEnderman.getRandomFireworkEffect());
            f.setFireworkMeta(fm);
            fireworks.add(f);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), () -> {
            for (Firework f : fireworks) {
                f.detonate();
            }
        }, 2L);
    }

    @Override
    public void onClear() {
        if (this.getPlayer().getGameMode() != GameMode.CREATIVE) {
            this.getPlayer().setAllowFlight(false);
        }
    }
}

