/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.morphs;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.morphs.Morph;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.shaded.xseries.messages.ActionBar;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.Particles;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.CreeperWatcher;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class MorphCreeper
extends Morph
implements PlayerAffectingCosmetic,
Updatable {
    private int charge = 0;

    public MorphCreeper(UltraPlayer owner, MorphType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void onUpdate() {
        CreeperWatcher creeperWatcher = (CreeperWatcher)this.disguise.getWatcher();
        if (this.getPlayer().isSneaking()) {
            creeperWatcher.setIgnited(true);
            if (this.charge + 4 <= 100) {
                this.charge += 4;
            }
            XSound.ENTITY_CREEPER_PRIMED.play((Entity)this.getPlayer(), 1.4f, 1.5f);
        } else {
            if (creeperWatcher.isIgnited()) {
                this.disguise = new MobDisguise(((MorphType)this.getType()).getDisguiseType());
                if (!this.getOwner().canSeeSelfMorph()) {
                    this.disguise.setViewSelfDisguise(false);
                }
                DisguiseAPI.disguiseToAll((Entity)this.getPlayer(), (Disguise)this.disguise);
            }
            if (this.charge == 100) {
                Particles.EXPLOSION_HUGE.display(this.getPlayer().getLocation());
                XSound.ENTITY_GENERIC_EXPLODE.play((Entity)this.getPlayer(), 1.4f, 1.5f);
                for (Entity ent : this.getPlayer().getNearbyEntities(3.0, 3.0, 3.0)) {
                    if (!this.canAffect(ent)) continue;
                    double dX = this.getPlayer().getLocation().getX() - ent.getLocation().getX();
                    double dY = this.getPlayer().getLocation().getY() - ent.getLocation().getY();
                    double dZ = this.getPlayer().getLocation().getZ() - ent.getLocation().getZ();
                    double yaw = Math.atan2(dZ, dX);
                    double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
                    double X = Math.sin(pitch) * Math.cos(yaw);
                    double Y = Math.sin(pitch) * Math.sin(yaw);
                    double Z = Math.cos(pitch);
                    Vector vector = new Vector(X, Z, Y);
                    MathUtils.applyVelocity(ent, vector.multiply(1.3).add(new Vector(0.0, 1.4, 0.0)));
                }
                ActionBar.clearActionBar(this.getPlayer());
                this.charge = 0;
                return;
            }
            if (this.charge > 0) {
                this.charge -= 4;
            }
        }
        if (this.charge > 0 && this.charge < 100) {
            if (this.charge < 5) {
                ActionBar.clearActionBar(this.getPlayer());
            } else {
                ActionBar.sendActionBar(this.getPlayer(), MessageManager.getMessage("Morphs.Creeper.charging").replace("%chargelevel%", this.charge + ""));
            }
        } else if (this.charge == 100) {
            ActionBar.sendActionBar(this.getPlayer(), MessageManager.getMessage("Morphs.Creeper.release-to-explode"));
        }
    }
}

