/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.morphs;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.morphs.Morph;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.Particles;
import be.isach.ultracosmetics.version.VersionManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class MorphChicken
extends Morph
implements Updatable {
    private List<Item> items = new ArrayList<Item>();
    private List<Chicken> chickens = new ArrayList<Chicken>();
    private boolean cooldown;

    public MorphChicken(UltraPlayer owner, MorphType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @EventHandler
    public void onPlayerToggleSneak(PlayerToggleSneakEvent event) {
        if (event.getPlayer() == this.getPlayer() && this.getOwner().getCurrentMorph() == this && !this.cooldown) {
            this.items = new ArrayList<Item>();
            for (int j = 0; j < 10; ++j) {
                this.items.add(ItemFactory.createUnpickableItemVariance(XMaterial.EGG, this.getPlayer().getLocation(), RANDOM, 0.5));
                XSound.ENTITY_CHICKEN_EGG.play((Entity)this.getPlayer(), 0.5f, 1.5f);
            }
            Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), new Runnable(){
                BukkitRunnable followRunnable;

                @Override
                public void run() {
                    MorphChicken.this.chickens = new ArrayList();
                    for (Item i : MorphChicken.this.items) {
                        if (VersionManager.IS_VERSION_1_13) {
                            i.getWorld().spawnParticle(Particle.BLOCK_CRACK, i.getLocation(), 0, 0.0, 0.0, 0.0, 0.0, (Object)XMaterial.WHITE_TERRACOTTA.parseMaterial().createBlockData());
                        } else {
                            Particles.BLOCK_CRACK.display((Particles.ParticleData)new Particles.BlockData(XMaterial.WHITE_TERRACOTTA.parseMaterial(), 0), 0.0f, 0.0f, 0.0f, 0.3f, 50, i.getLocation(), 128.0);
                        }
                        XSound.ENTITY_ZOMBIE_ATTACK_WOODEN_DOOR.play(i.getLocation(), 0.05f, 1.0f);
                        Chicken chicken = (Chicken)i.getWorld().spawnEntity(i.getLocation(), EntityType.CHICKEN);
                        chicken.setAgeLock(true);
                        chicken.setBaby();
                        chicken.setNoDamageTicks(Integer.MAX_VALUE);
                        chicken.setVelocity(new Vector(0.0f, 0.5f, 0.0f));
                        UltraCosmeticsData.get().getVersionManager().getEntityUtil().clearPathfinders((Entity)chicken);
                        UltraCosmeticsData.get().getVersionManager().getEntityUtil().follow((Entity)MorphChicken.this.getPlayer(), (Entity)chicken);
                        i.remove();
                        MorphChicken.this.chickens.add(chicken);
                    }
                    new BukkitRunnable(){

                        public void run() {
                            if (MorphChicken.this.chickens.isEmpty()) {
                                this.cancel();
                            }
                            for (Chicken chicken : MorphChicken.this.chickens) {
                                UltraCosmeticsData.get().getVersionManager().getEntityUtil().follow((Entity)MorphChicken.this.getPlayer(), (Entity)chicken);
                            }
                        }
                    }.runTaskTimer((Plugin)MorphChicken.this.getUltraCosmetics(), 0L, 4L);
                    Bukkit.getScheduler().runTaskLater((Plugin)MorphChicken.this.getUltraCosmetics(), () -> {
                        for (Chicken chicken : MorphChicken.this.chickens) {
                            Particles.LAVA.display(chicken.getLocation(), 10);
                            chicken.remove();
                        }
                        MorphChicken.this.chickens.clear();
                        if (this.followRunnable != null) {
                            this.followRunnable.cancel();
                        }
                    }, 200L);
                }
            }, 50L);
            this.cooldown = true;
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.getUltraCosmetics(), () -> {
                this.cooldown = false;
            }, 600L);
        }
    }

    @EventHandler
    public void onItemMerge(ItemMergeEvent event) {
        if (this.items.contains(event.getEntity()) || this.items.contains(event.getTarget())) {
            event.setCancelled(true);
        }
    }

    @Override
    protected void onClear() {
        for (Chicken chicken : this.chickens) {
            Particles.LAVA.display(chicken.getLocation(), 10);
            chicken.remove();
        }
        this.chickens.clear();
    }

    @Override
    public void onUpdate() {
        Player player = this.getPlayer();
        boolean onGround = player.isOnGround();
        if (onGround || player.getVelocity().getY() >= 0.0) {
            return;
        }
        player.setVelocity(player.getVelocity().multiply(0.85));
    }
}

