/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.Particles;
import be.isach.ultracosmetics.version.VersionManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class GadgetSmashDown
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private boolean active = false;
    private List<FallingBlock> fallingBlocks = new ArrayList<FallingBlock>();
    private int i = 1;
    private boolean playEffect;

    public GadgetSmashDown(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.play(XSound.ENTITY_FIREWORK_ROCKET_LAUNCH, this.getPlayer().getLocation(), 2.0f, 1.0f);
        this.getPlayer().setVelocity(new Vector(0, 3, 0));
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                if (GadgetSmashDown.this.getOwner() != null && GadgetSmashDown.this.getPlayer() != null && GadgetSmashDown.this.isEquipped()) {
                    Particles.CLOUD.display(GadgetSmashDown.this.getPlayer().getLocation());
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.getUltraCosmetics(), 0L, 1L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), () -> {
            if (this.getOwner() != null && this.getPlayer() != null && this.isEquipped()) {
                task.cancel();
                this.getOwner().applyVelocity(new Vector(0, -3, 0));
                this.active = true;
            }
        }, 25L);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (this.active && event.getEntity() == this.getPlayer()) {
            event.setCancelled(true);
        }
    }

    @Override
    public void onUpdate() {
        if (this.active && this.getPlayer().isOnGround()) {
            this.playEffect = true;
            Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.getUltraCosmetics(), () -> {
                this.active = false;
            }, 5L);
            return;
        }
        if (!this.playEffect) {
            return;
        }
        Location loc = this.getPlayer().getLocation();
        this.play(XSound.ENTITY_GENERIC_EXPLODE, this.getPlayer().getLocation(), 2.0f, 1.0f);
        if (this.i == 5) {
            this.playEffect = false;
            this.active = false;
            this.i = 1;
            return;
        }
        if (this.getOwner().getCurrentGadget() != this) {
            this.playEffect = false;
            this.active = false;
            return;
        }
        for (Block b : BlockUtils.getBlocksInRadius(loc.clone().add(0.0, -1.0, 0.0), this.i, true)) {
            if (b.getLocation().getBlockY() != loc.getBlockY() - 1 || BlockUtils.isBadMaterial(b.getType()) || BlockUtils.isRocketBlock(b) || BlockUtils.isTreasureChestBlock(b) || !b.getType().isSolid() || !BlockUtils.isAir(b.getRelative(BlockFace.UP).getType())) continue;
            Bukkit.getScheduler().runTask((Plugin)this.getUltraCosmetics(), () -> {
                FallingBlock fb = BlockUtils.spawnFallingBlock(b.getLocation().clone().add(0.0, (double)1.1f, 0.0), b);
                fb.setVelocity(new Vector(0.0f, 0.3f, 0.0f));
                fb.setDropItem(false);
                this.fallingBlocks.add(fb);
                fb.getNearbyEntities(1.0, 1.0, 1.0).stream().filter(ent -> ent != this.getPlayer() && !(ent instanceof FallingBlock) && this.canAffect((Entity)ent)).forEach(ent -> MathUtils.applyVelocity(ent, new Vector(0.0, 0.5, 0.0)));
            });
        }
        ++this.i;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockChangeState(EntityChangeBlockEvent event) {
        if (this.fallingBlocks.contains(event.getEntity())) {
            event.setCancelled(true);
            this.fallingBlocks.remove(event.getEntity());
            FallingBlock fb = (FallingBlock)event.getEntity();
            if (VersionManager.IS_VERSION_1_13) {
                BlockData data = fb.getBlockData();
                fb.getWorld().spawnParticle(Particle.BLOCK_CRACK, fb.getLocation(), 50, 0.0, 0.0, 0.0, 0.4, (Object)data);
            } else {
                Particles.BLOCK_CRACK.display((Particles.ParticleData)new Particles.BlockData(fb.getMaterial(), event.getBlock().getData()), 0.0f, 0.0f, 0.0f, 0.4f, 50, fb.getLocation(), 128.0);
            }
            this.play(XSound.BLOCK_ANVIL_BREAK, this.getPlayer().getLocation(), 0.05f, 1.0f);
            event.getEntity().remove();
        }
    }

    @Override
    public void onClear() {
        for (FallingBlock block : this.fallingBlocks) {
            block.remove();
        }
    }
}

