/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.run.FallDamageManager;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.util.Area;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.Particles;
import be.isach.ultracosmetics.version.VersionManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.spigotmc.event.entity.EntityDismountEvent;

public class GadgetRocket
extends Gadget
implements Updatable {
    private static final boolean DISMOUNT_CANCELLABLE = VersionManager.IS_VERSION_1_13;
    private static final BlockFace[] CARDINAL = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    private static final Material FENCE = XMaterial.OAK_FENCE.parseMaterial();
    public static final Set<GadgetRocket> ROCKETS_WITH_BLOCKS = new HashSet<GadgetRocket>();
    private boolean stillEquipped = true;
    private boolean launching;
    private ArmorStand armorStand;
    private Map<Block, BlockState> blocks = new HashMap<Block, BlockState>();
    private List<FallingBlock> fallingBlocks = new ArrayList<FallingBlock>();
    private Entity playerVehicle = null;
    private BukkitTask currentTask = null;

    public GadgetRocket(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.getPlayer().setVelocity(new Vector(0, 1, 0));
        Location loc = this.getPlayer().getLocation();
        loc.setX((double)loc.getBlockX() + 0.5);
        loc.setY((double)loc.getBlockY());
        loc.setZ((double)loc.getBlockZ() + 0.5);
        Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), () -> {
            if (this.getOwner() == null || this.getOwner().getCurrentGadget() != this) {
                return;
            }
            ROCKETS_WITH_BLOCKS.add(this);
            for (int i = 0; i < 2; ++i) {
                Block center = loc.clone().add(0.0, (double)i, 0.0).getBlock();
                for (BlockFace face : CARDINAL) {
                    Block side = center.getRelative(face);
                    this.blocks.put(side, side.getState());
                    side.setType(FENCE);
                }
                Block quartz = center.getRelative(BlockFace.UP);
                this.blocks.put(quartz, quartz.getState());
                quartz.setType(Material.QUARTZ_BLOCK);
            }
            this.armorStand = (ArmorStand)loc.getWorld().spawn(loc.add(0.0, 1.5, 0.0), ArmorStand.class);
            this.armorStand.setVisible(false);
            this.armorStand.setGravity(false);
        }, 10L);
        Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), () -> {
            if (this.getOwner() == null || this.getOwner().getCurrentGadget() != this) {
                return;
            }
            this.enableFlight();
            this.playerVehicle = null;
            this.armorStand.setPassenger((Entity)this.getPlayer());
            this.playerVehicle = this.armorStand;
            new BukkitRunnable(){
                int i = 5;

                public void run() {
                    if (GadgetRocket.this.getOwner() == null || GadgetRocket.this.getPlayer() == null || !GadgetRocket.this.getPlayer().isOnline()) {
                        this.cancel();
                        return;
                    }
                    if (!GadgetRocket.this.isStillCurrentGadget()) {
                        this.cancel();
                        return;
                    }
                    if (this.i > 0) {
                        GadgetRocket.this.sendTitle(ChatColor.RED + "" + ChatColor.BOLD + this.i);
                        GadgetRocket.this.play(XSound.BLOCK_NOTE_BLOCK_BASS, (Entity)GadgetRocket.this.getPlayer(), 1.0f, 1.0f);
                        --this.i;
                        return;
                    }
                    if (GadgetRocket.this.isTaskRunning()) {
                        GadgetRocket.this.onClear();
                        GadgetRocket.this.sendTitle(MessageManager.getMessage("Gadgets.Rocket.LaunchAborted"));
                        this.cancel();
                        return;
                    }
                    GadgetRocket.this.sendTitle(MessageManager.getMessage("Gadgets.Rocket.Takeoff"));
                    GadgetRocket.this.play(XSound.ENTITY_GENERIC_EXPLODE, GadgetRocket.this.getPlayer().getLocation(), 1.0f, 1.0f);
                    GadgetRocket.this.playerVehicle = null;
                    GadgetRocket.this.armorStand.remove();
                    GadgetRocket.this.armorStand = null;
                    for (BlockState state : GadgetRocket.this.blocks.values()) {
                        state.update(true);
                    }
                    GadgetRocket.this.blocks.clear();
                    ROCKETS_WITH_BLOCKS.remove(GadgetRocket.this);
                    FallingBlock top = BlockUtils.spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(0.0, 3.0, 0.0), Material.QUARTZ_BLOCK);
                    FallingBlock base = BlockUtils.spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(0.0, 2.0, 0.0), Material.QUARTZ_BLOCK);
                    for (int i = 0; i < 2; ++i) {
                        GadgetRocket.this.fallingBlocks.add(BlockUtils.spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(0.0, (double)(1 + i), 1.0), FENCE));
                        GadgetRocket.this.fallingBlocks.add(BlockUtils.spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(0.0, (double)(1 + i), -1.0), FENCE));
                        GadgetRocket.this.fallingBlocks.add(BlockUtils.spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(1.0, (double)(1 + i), 0.0), FENCE));
                        GadgetRocket.this.fallingBlocks.add(BlockUtils.spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(-1.0, (double)(1 + i), 0.0), FENCE));
                    }
                    GadgetRocket.this.fallingBlocks.add(top);
                    GadgetRocket.this.fallingBlocks.add(base);
                    if (((FallingBlock)GadgetRocket.this.fallingBlocks.get(8)).getPassenger() == null) {
                        ((FallingBlock)GadgetRocket.this.fallingBlocks.get(8)).setPassenger((Entity)GadgetRocket.this.getPlayer());
                    }
                    top.setPassenger((Entity)GadgetRocket.this.getPlayer());
                    GadgetRocket.this.playerVehicle = (Entity)top;
                    GadgetRocket.this.launching = true;
                    Bukkit.getScheduler().runTaskLater((Plugin)GadgetRocket.this.getUltraCosmetics(), () -> {
                        GadgetRocket.this.playerVehicle = null;
                        if (!GadgetRocket.this.isStillCurrentGadget()) {
                            this.cancel();
                            return;
                        }
                        GadgetRocket.this.fallingBlocks.forEach(Entity::remove);
                        GadgetRocket.this.fallingBlocks.clear();
                        FallDamageManager.addNoFall((Entity)GadgetRocket.this.getPlayer());
                        GadgetRocket.this.play(XSound.ENTITY_GENERIC_EXPLODE, GadgetRocket.this.getPlayer().getLocation(), 1.0f, 1.0f);
                        Particles.EXPLOSION_HUGE.display(GadgetRocket.this.getPlayer().getLocation());
                        GadgetRocket.this.disableFlight();
                        GadgetRocket.this.launching = false;
                    }, 80L);
                    this.cancel();
                }
            }.runTaskTimer((Plugin)this.getUltraCosmetics(), 0L, 20L);
        }, 12L);
    }

    @Override
    protected boolean checkRequirements(PlayerInteractEvent event) {
        Area area = new Area(this.getPlayer().getLocation(), 1, 75);
        if (!area.isEmpty()) {
            this.getPlayer().sendMessage(MessageManager.getMessage("Gadgets.Rocket.Not-Enough-Space"));
            return false;
        }
        if (!this.getPlayer().isOnGround()) {
            this.getPlayer().sendMessage(MessageManager.getMessage("Gadgets.Rocket.Not-On-Ground"));
            return false;
        }
        return true;
    }

    private boolean isStillCurrentGadget() {
        return this.stillEquipped;
    }

    @Override
    public void onUpdate() {
        for (FallingBlock fallingBlock : this.fallingBlocks) {
            fallingBlock.setVelocity(new Vector(0.0, 0.8, 0.0));
        }
        if (this.launching && !this.fallingBlocks.isEmpty()) {
            Particles.FLAME.display(0.3f, (double)0.2f, (double)0.3f, this.getPlayer().getLocation().add(0.0, -3.0, 0.0), 10);
            Particles.LAVA.display(0.3f, (double)0.2f, (double)0.3f, this.getPlayer().getLocation().add(0.0, -3.0, 0.0), 10);
            this.play(XSound.ENTITY_BAT_LOOP, this.fallingBlocks.get(9).getLocation().clone().add(0.0, -1.0, 0.0), 1.5f, 1.0f);
            this.play(XSound.BLOCK_FIRE_EXTINGUISH, this.fallingBlocks.get(9).getLocation().clone().add(0.0, -1.0, 0.0), 0.025f, 1.0f);
        }
    }

    @Override
    public void onClear() {
        this.stillEquipped = false;
        for (BlockState state : this.blocks.values()) {
            state.update(true);
        }
        for (FallingBlock fallingBlock : this.fallingBlocks) {
            fallingBlock.remove();
        }
        this.blocks.clear();
        this.playerVehicle = null;
        this.fallingBlocks.clear();
        if (this.armorStand != null) {
            this.armorStand.remove();
        }
        this.disableFlight();
        this.launching = false;
        if (this.getPlayer() != null) {
            this.sendTitle(" ");
        }
    }

    public boolean containsBlock(Block block) {
        return this.blocks.containsKey(block);
    }

    @EventHandler
    public void onDismount(EntityDismountEvent event) {
        if (event.getEntity() != this.getPlayer()) {
            return;
        }
        if (event.getDismounted() != this.playerVehicle) {
            return;
        }
        if (this.isTaskRunning()) {
            return;
        }
        if (DISMOUNT_CANCELLABLE) {
            event.setCancelled(true);
            return;
        }
        this.disableFlight();
        this.currentTask = new BukkitRunnable(){

            public void run() {
                if (GadgetRocket.this.getPlayer() == null) {
                    return;
                }
                if (GadgetRocket.this.playerVehicle == null) {
                    return;
                }
                Entity vehicle = GadgetRocket.this.playerVehicle;
                GadgetRocket.this.playerVehicle = null;
                boolean success = vehicle.setPassenger((Entity)GadgetRocket.this.getPlayer());
                GadgetRocket.this.playerVehicle = vehicle;
                if (!success) {
                    return;
                }
                this.cancel();
                GadgetRocket.this.enableFlight();
                if (vehicle instanceof ArmorStand) {
                    Particles.SMOKE_LARGE.display(0.3f, (double)0.2f, (double)0.3f, GadgetRocket.this.armorStand.getLocation().add(0.0, -3.0, 0.0), 10);
                    GadgetRocket.this.play(XSound.BLOCK_FIRE_EXTINGUISH, GadgetRocket.this.armorStand.getLocation().clone().add(0.0, -3.0, 0.0), 0.025f, 1.0f);
                }
            }
        }.runTaskTimer((Plugin)this.getUltraCosmetics(), 2L, 1L);
    }

    private void enableFlight() {
        this.getPlayer().setAllowFlight(true);
    }

    private void disableFlight() {
        if (this.getPlayer().getGameMode() != GameMode.CREATIVE) {
            this.getPlayer().setAllowFlight(false);
        }
    }

    private boolean isTaskRunning() {
        return this.currentTask != null && Bukkit.getScheduler().isQueued(this.currentTask.getTaskId());
    }

    private void sendTitle(String title) {
        this.getPlayer().sendTitle(title, "");
    }
}

