/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.Particles;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GadgetQuakeGun
extends Gadget
implements PlayerAffectingCosmetic {
    private static final FireworkEffect FIREWORK_EFFECT = FireworkEffect.builder().flicker(false).trail(false).with(FireworkEffect.Type.BALL_LARGE).withColor(Color.RED).withFade(Color.ORANGE).build();
    private List<Firework> fireworkList = new ArrayList<Firework>();

    public GadgetQuakeGun(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.play(XSound.ENTITY_BLAZE_DEATH, (Entity)this.getPlayer(), 1.4f, 1.5f);
        Location location = this.getPlayer().getEyeLocation().subtract(0.0, 0.4, 0.0);
        Vector vector = location.getDirection();
        for (int i = 0; i < 20; ++i) {
            Firework firework = (Firework)location.getWorld().spawnEntity(location, EntityType.FIREWORK);
            location.add(vector);
            this.fireworkList.add(firework);
            List nearbyEntities = firework.getNearbyEntities(0.5, 0.5, 0.5);
            for (Entity entity : nearbyEntities) {
                if (!(entity instanceof Player) && !(entity instanceof Creature) || entity == this.getPlayer() || !this.canAffect(entity)) continue;
                MathUtils.applyVelocity(entity, new Vector(0, 1, 0));
                Particles.FLAME.display(entity.getLocation(), 60, 0.4f);
                UltraCosmeticsData.get().getVersionManager().getFireworkFactory().spawn(location, FIREWORK_EFFECT, new Player[0]);
            }
        }
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.getUltraCosmetics(), () -> {
            for (Firework firework : this.fireworkList) {
                UltraCosmeticsData.get().getVersionManager().getEntityUtil().sendDestroyPacket(this.getPlayer(), (Entity)firework);
            }
        }, 6L);
    }
}

