/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.Particles;
import be.isach.ultracosmetics.util.PortalLoc;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GadgetPortalGun
extends Gadget
implements Updatable {
    private static final double CIRCLE_STEP = 0.3141592653589793;
    private boolean teleported = false;
    private PortalLoc red = new PortalLoc(255, 0, 0);
    private PortalLoc blue = new PortalLoc(31, 0, 127);

    public GadgetPortalGun(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
        this.displayCooldownMessage = false;
    }

    @Override
    protected void onRightClick() {
        this.handleClick(this.blue);
    }

    @Override
    protected void onLeftClick() {
        this.handleClick(this.red);
    }

    private void handleClick(PortalLoc portalLoc) {
        this.play(XSound.ENTITY_ENDERMAN_TELEPORT, (Entity)this.getPlayer(), 0.2f, 1.5f);
        List sight = this.getPlayer().getLastTwoTargetBlocks(null, 20);
        Block target = (Block)sight.get(1);
        Location playerFaceLoc = this.getPlayer().getEyeLocation().add(this.getPlayer().getEyeLocation().getDirection().multiply(0.6));
        Particles.REDSTONE.drawParticleLine(playerFaceLoc, target.getLocation(), 100, portalLoc.getRed(), portalLoc.getGreen(), portalLoc.getBlue());
        BlockFace face = this.getBlockFace((Block)sight.get(0), target);
        Location loc = target.getRelative(face).getLocation().add(0.5, 0.5, 0.5);
        loc.add(face.getDirection().multiply(-0.25));
        portalLoc.setLocation(loc);
        portalLoc.setFace(face);
    }

    public float getPitch(BlockFace bf) {
        if (bf == BlockFace.UP) {
            return -90.0f;
        }
        if (bf == BlockFace.DOWN) {
            return 90.0f;
        }
        return 0.0f;
    }

    public float getYaw(BlockFace bf) {
        if (bf == BlockFace.WEST) {
            return 90.0f;
        }
        if (bf == BlockFace.EAST) {
            return -90.0f;
        }
        if (bf == BlockFace.NORTH) {
            return 180.0f;
        }
        return 0.0f;
    }

    public BlockFace getBlockFace(Block a, Block b) {
        for (BlockFace bf : BlockFace.values()) {
            if (!a.getRelative(bf).getLocation().equals((Object)b.getLocation())) continue;
            return bf.getOppositeFace();
        }
        return null;
    }

    private boolean portalTeleportCheck(PortalLoc portalLoc, PortalLoc dest) {
        BlockFace face = portalLoc.getFace();
        Location playerLoc = face == BlockFace.DOWN ? this.getPlayer().getEyeLocation() : (face == BlockFace.UP ? this.getPlayer().getLocation() : this.getPlayer().getLocation().add(0.0, 1.0, 0.0));
        if (playerLoc.getWorld() != this.getPlayer().getWorld() || playerLoc.distanceSquared(portalLoc.getLocation()) > 1.0) {
            return false;
        }
        this.teleported = true;
        Location loc = dest.getLocation().clone();
        BlockFace destFace = dest.getFace();
        loc.setYaw(this.getYaw(destFace));
        loc.setPitch(this.getPitch(destFace));
        this.teleport((Entity)this.getPlayer(), loc, destFace.getDirection().multiply(0.3));
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.getUltraCosmetics(), () -> {
            this.teleported = false;
        }, 20L);
        return true;
    }

    private void checkPortals() {
        if (!this.red.isValid() || !this.blue.isValid() || this.teleported) {
            return;
        }
        if (this.red.getLocation().getWorld() != this.blue.getLocation().getWorld()) {
            this.red.clear();
            this.blue.clear();
            this.getPlayer().sendMessage(MessageManager.getMessage("Gadgets.PortalGun.Different-Worlds"));
            return;
        }
        if (!this.portalTeleportCheck(this.red, this.blue)) {
            this.portalTeleportCheck(this.blue, this.red);
        }
    }

    private void showParticles(PortalLoc portalLoc) {
        if (!portalLoc.isValid()) {
            return;
        }
        Location loc = portalLoc.getLocation().clone();
        BlockFace face = portalLoc.getFace();
        for (int i = 0; i < 20; ++i) {
            double angle = (double)i * 0.3141592653589793;
            Vector v = new Vector();
            double a1 = Math.cos(angle);
            double a2 = Math.sin(angle);
            if (face == BlockFace.NORTH || face == BlockFace.SOUTH) {
                v.setX(a1);
                v.setY(a2);
            } else if (face == BlockFace.EAST || face == BlockFace.WEST) {
                v.setY(a1);
                v.setZ(a2);
            } else {
                v.setX(a1);
                v.setZ(a2);
            }
            Particles.REDSTONE.display(portalLoc.getRed(), portalLoc.getGreen(), portalLoc.getBlue(), loc.clone().add(v));
        }
    }

    @Override
    public void onUpdate() {
        this.checkPortals();
        this.showParticles(this.red);
        this.showParticles(this.blue);
    }

    @Override
    protected boolean checkRequirements(PlayerInteractEvent event) {
        List sight = this.getPlayer().getLastTwoTargetBlocks(null, 20);
        if (sight.size() < 2 || BlockUtils.isAir(((Block)sight.get(1)).getType())) {
            this.getPlayer().sendMessage(MessageManager.getMessage("Gadgets.PortalGun.No-Block-Range"));
            return false;
        }
        return true;
    }

    private void teleport(Entity entity, Location location, Vector velocity) {
        Bukkit.getScheduler().runTask((Plugin)this.getUltraCosmetics(), () -> {
            entity.teleport(location);
            entity.setVelocity(velocity);
            if (entity instanceof Player) {
                this.play(XSound.ENTITY_ENDERMAN_TELEPORT, entity, 1.0f, 1.0f);
            }
        });
    }

    @Override
    public void onClear() {
        this.red.clear();
        this.blue.clear();
    }
}

