/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.Area;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.EntitySpawner;
import be.isach.ultracosmetics.util.MathUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityUnleashEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GadgetParachute
extends Gadget
implements Updatable {
    private EntitySpawner<Chicken> chickens;
    private boolean active;

    public GadgetParachute(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void onRightClick() {
        Location loc = this.getPlayer().getLocation();
        this.getPlayer().teleport(loc.add(0.0, 35.0, 0.0));
        this.getPlayer().setVelocity(new Vector(0, 0, 0));
        this.getOwner().setCanBeHitByOtherGadgets(false);
        this.chickens = new EntitySpawner<Chicken>(EntityType.CHICKEN, loc.add(0.0, 3.0, 0.0), 20, true, c -> c.setLeashHolder((Entity)this.getPlayer()), this.getUltraCosmetics());
        Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), () -> {
            this.active = true;
        }, 5L);
    }

    private void killParachute() {
        if (this.chickens != null) {
            for (Chicken chicken : this.chickens.getEntities()) {
                chicken.setLeashHolder(null);
            }
            this.chickens.removeEntities();
        }
        MathUtils.applyVelocity((Entity)this.getPlayer(), new Vector(0.0, 0.15, 0.0));
        this.active = false;
        this.getOwner().setCanBeHitByOtherGadgets(true);
    }

    @EventHandler
    public void onChickenDeath(EntityDeathEvent event) {
        if (this.chickens == null) {
            return;
        }
        if (this.chickens.contains((Entity)event.getEntity())) {
            event.setDroppedExp(0);
            event.getDrops().clear();
            event.getEntity().setLeashHolder(null);
            this.chickens.removeEntity((Entity)event.getEntity());
        }
    }

    @EventHandler
    public void onChickenUnleash(EntityUnleashEvent event) {
        if (this.chickens == null) {
            return;
        }
        if (this.chickens.contains(event.getEntity())) {
            ((Chicken)event.getEntity()).setLeashHolder(null);
            this.chickens.removeEntity(event.getEntity());
        }
    }

    @Override
    protected boolean checkRequirements(PlayerInteractEvent event) {
        Location loc2;
        Location loc1 = this.getPlayer().getLocation().add(2.0, 28.0, 2.0);
        Area checkArea = new Area(loc1, loc2 = this.getPlayer().getLocation().clone().add(-2.0, 40.0, -2.0));
        if (!checkArea.isEmpty()) {
            this.getPlayer().sendMessage(MessageManager.getMessage("Gadgets.Rocket.Not-Enough-Space"));
            return false;
        }
        return true;
    }

    @Override
    public void onUpdate() {
        if (this.active) {
            if (!this.isNotOnAir(this.getPlayer()) && this.getPlayer().getVelocity().getY() < -0.3) {
                MathUtils.applyVelocity((Entity)this.getPlayer(), this.getPlayer().getVelocity().add(new Vector(0.0, 0.1, 0.0)));
            }
            if (this.isNotOnAir(this.getPlayer())) {
                this.killParachute();
            }
        }
    }

    private boolean isNotOnAir(Player p) {
        return !BlockUtils.isAir(p.getLocation().getBlock().getRelative(BlockFace.DOWN).getType());
    }

    @Override
    public void onClear() {
        this.killParachute();
    }
}

