/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.Particles;
import be.isach.ultracosmetics.util.ServerVersion;
import be.isach.ultracosmetics.util.SmartLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;

public class GadgetPaintballGun
extends Gadget {
    private static final List<XMaterial> PAINT_BLOCKS = new ArrayList<XMaterial>();
    private final Set<Projectile> projectiles = new HashSet<Projectile>();
    private final int radius = SettingsManager.getConfig().getInt("Gadgets." + ((GadgetType)this.getType()).getConfigName() + ".Radius", 2);

    public GadgetPaintballGun(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
        this.displayCooldownMessage = false;
    }

    @Override
    protected void onRightClick() {
        Projectile projectile = this.getPlayer().launchProjectile(EnderPearl.class, this.getPlayer().getLocation().getDirection().multiply(2));
        this.projectiles.add(projectile);
        this.play(XSound.ENTITY_CHICKEN_EGG, (Entity)this.getPlayer(), 1.5f, 1.2f);
    }

    @EventHandler
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        for (Projectile proj : this.projectiles) {
            if (!(proj.getLocation().distanceSquared(event.getVehicle().getLocation()) < 100.0)) continue;
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemFrameBreak(HangingBreakByEntityEvent event) {
        if (event.getRemover() instanceof Projectile) {
            if (this.projectiles.contains(event.getRemover())) {
                event.setCancelled(true);
            }
        } else if (event.getRemover() == this.getPlayer()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        if (this.projectiles.remove(event.getEntity())) {
            Location center = event.getEntity().getLocation().add(event.getEntity().getVelocity());
            HashMap<Block, XMaterial> updates = new HashMap<Block, XMaterial>();
            for (Block block : BlockUtils.getBlocksInRadius(center.getBlock().getLocation(), this.radius, false)) {
                updates.put(block, PAINT_BLOCKS.get(RANDOM.nextInt(PAINT_BLOCKS.size())));
            }
            BlockUtils.setToRestore(updates, 60);
            if (SettingsManager.getConfig().getBoolean("Gadgets." + ((GadgetType)this.getType()).getConfigName() + ".Particle.Enabled")) {
                Particles effect = Particles.valueOf(SettingsManager.getConfig().getString("Gadgets." + ((GadgetType)this.getType()).getConfigName() + ".Particle.Effect").replace("_", ""));
                effect.display(2.5, (double)0.2f, 2.5, center.clone().add(0.5, (double)1.2f, 0.5), 50);
            }
            event.getEntity().remove();
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType() != EntityType.ENDER_PEARL) {
            return;
        }
        if (this.projectiles.contains(event.getDamager())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityTeleport(PlayerTeleportEvent event) {
        if (event.getPlayer().getUniqueId().equals(this.getOwnerUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (UltraCosmeticsData.get().getServerVersion() != ServerVersion.v1_8 && event.getSpawnReason() == CreatureSpawnEvent.SpawnReason.ENDER_PEARL) {
            event.setCancelled(true);
        }
    }

    @Override
    public void onClear() {
        for (Projectile projectile : this.projectiles) {
            projectile.remove();
        }
        this.projectiles.clear();
    }

    static {
        String ending = SettingsManager.getConfig().getString("Gadgets.PaintballGun.Block-Type", "_TERRACOTTA").toUpperCase();
        for (XMaterial mat : XMaterial.VALUES) {
            if (!mat.name().endsWith(ending)) continue;
            PAINT_BLOCKS.add(mat);
        }
        if (PAINT_BLOCKS.isEmpty()) {
            UltraCosmeticsData.get().getPlugin().getSmartLogger().write(SmartLogger.LogLevel.ERROR, "Paintball Gun setting 'Block-Type' does not match any known blocks.");
            PAINT_BLOCKS.add(XMaterial.BEDROCK);
        }
    }
}

