/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Effect;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class GadgetMelonThrower
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private Item melon = null;
    private final Set<Item> melonSlices = new HashSet<Item>();

    public GadgetMelonThrower(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @EventHandler
    public void onTakeUpMelon(PlayerPickupItemEvent event) {
        if (this.melonSlices.contains(event.getItem()) && event.getItem().getTicksLived() > 5 && this.canAffect((Entity)event.getPlayer())) {
            event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 100, 2));
            this.play(XSound.ENTITY_PLAYER_BURP, this.getPlayer().getLocation(), 1.4f, 1.5f);
            event.getItem().remove();
            this.melonSlices.remove(event.getItem());
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemMerge(ItemMergeEvent event) {
        if (this.melonSlices.contains(event.getEntity()) || this.melonSlices.contains(event.getTarget())) {
            event.setCancelled(true);
        }
    }

    @Override
    protected boolean checkRequirements(PlayerInteractEvent event) {
        if (this.melon != null) {
            event.getPlayer().sendMessage(MessageManager.getMessage("Gadgets.MelonThrower.Wait-For-Finish"));
            return false;
        }
        return true;
    }

    @Override
    protected void onRightClick() {
        this.play(XSound.ENTITY_GENERIC_EXPLODE, this.getPlayer().getLocation(), 1.4f, 1.5f);
        this.melon = ItemFactory.createUnpickableItemDirectional(XMaterial.MELON, this.getPlayer(), 1.3);
    }

    @Override
    public void onUpdate() {
        if (this.melon == null || !this.melon.isValid()) {
            return;
        }
        if (this.melon.isOnGround()) {
            this.melon.getWorld().playEffect(this.melon.getLocation(), Effect.STEP_SOUND, 103);
            for (int i = 0; i < 8; ++i) {
                this.melonSlices.add(ItemFactory.createUnpickableItemVariance(XMaterial.MELON_SLICE, this.melon.getLocation(), RANDOM, 0.75));
            }
            new BukkitRunnable(){

                public void run() {
                    for (Item slice : GadgetMelonThrower.this.melonSlices) {
                        slice.remove();
                    }
                    GadgetMelonThrower.this.melonSlices.clear();
                }
            }.runTaskLater((Plugin)this.getUltraCosmetics(), 100L);
            this.melon.remove();
            this.melon = null;
        }
    }

    @Override
    public void onClear() {
        if (this.melon != null) {
            this.melon.remove();
        }
        for (Item slice : this.melonSlices) {
            slice.remove();
        }
        this.melonSlices.clear();
    }
}

