/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.Particles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;

public class GadgetFreezeCannon
extends Gadget
implements Updatable {
    private Set<Item> items = new HashSet<Item>();

    public GadgetFreezeCannon(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        Item item = this.getPlayer().getWorld().dropItem(this.getPlayer().getEyeLocation(), new ItemStack(Material.ICE));
        item.setVelocity(this.getPlayer().getEyeLocation().getDirection().multiply(0.9));
        this.items.add(item);
    }

    @EventHandler
    public void onPickup(PlayerPickupItemEvent event) {
        if (this.items.contains(event.getItem())) {
            event.setCancelled(true);
        }
    }

    @Override
    public void onUpdate() {
        Iterator<Item> iter = this.items.iterator();
        HashMap<Block, XMaterial> updates = new HashMap<Block, XMaterial>();
        while (iter.hasNext()) {
            Item item = iter.next();
            if (!item.isOnGround()) continue;
            for (Block b : BlockUtils.getBlocksInRadius(item.getLocation(), 4, false)) {
                updates.put(b, XMaterial.PACKED_ICE);
            }
            Particles.FIREWORKS_SPARK.display(4.0, 3.0, 4.0, item.getLocation(), 80);
            item.remove();
            iter.remove();
        }
        BlockUtils.setToRestore(updates, 50);
    }

    @Override
    public void onClear() {
        for (Item item : this.items) {
            item.remove();
        }
        this.items.clear();
    }
}

