/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.MathUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.EntityEffect;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GadgetFleshHook
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private Set<Item> items = new HashSet<Item>();

    public GadgetFleshHook(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @EventHandler
    public void onItemPickup(PlayerPickupItemEvent event) {
        UltraPlayer ultraPlayer = this.getUltraCosmetics().getPlayerManager().getUltraPlayer(event.getPlayer());
        if (ultraPlayer != null && !ultraPlayer.canBeHitByOtherGadgets()) {
            event.setCancelled(true);
            return;
        }
        if (this.items.contains(event.getItem())) {
            event.setCancelled(true);
            if (event.getPlayer() == this.getPlayer() || !this.canAffect((Entity)event.getPlayer())) {
                return;
            }
            this.items.remove(event.getItem());
            event.getItem().remove();
            Player HIT = event.getPlayer();
            HIT.playEffect(EntityEffect.HURT);
            Player hitter = this.getPlayer();
            double dX = HIT.getLocation().getX() - hitter.getLocation().getX();
            double dY = HIT.getLocation().getY() - hitter.getLocation().getY();
            double dZ = HIT.getLocation().getZ() - hitter.getLocation().getZ();
            double yaw = Math.atan2(dZ, dX);
            double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
            double X = Math.sin(pitch) * Math.cos(yaw);
            double Y = Math.sin(pitch) * Math.sin(yaw);
            double Z = Math.cos(pitch);
            Vector vector = new Vector(X, Z, Y);
            MathUtils.applyVelocity((Entity)HIT, vector.multiply(2.5).add(new Vector(0.0, 1.45, 0.0)));
        }
    }

    @Override
    protected void onRightClick() {
        this.items.add(ItemFactory.createUnpickableItemDirectional(XMaterial.TRIPWIRE_HOOK, this.getPlayer(), 1.5));
    }

    @Override
    public void onUpdate() {
        Bukkit.getScheduler().runTask((Plugin)this.getUltraCosmetics(), () -> {
            Iterator<Item> it = this.items.iterator();
            while (it.hasNext()) {
                Item pair = it.next();
                if (!pair.isOnGround()) continue;
                pair.remove();
                it.remove();
            }
        });
    }

    @Override
    public void onClear() {
        for (Item item : this.items) {
            item.remove();
        }
        this.items.clear();
    }
}

