/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.util.EntitySpawner;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.Particles;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetExplosiveSheep
extends Gadget {
    private Set<Sheep> sheeps = new HashSet<Sheep>();
    private BukkitRunnable sheepExplosionRunnable = null;

    public GadgetExplosiveSheep(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        Location loc = this.getPlayer().getLocation().add(this.getPlayer().getEyeLocation().getDirection().multiply(0.5));
        loc.setY((double)(this.getPlayer().getLocation().getBlockY() + 1));
        Sheep sheep = (Sheep)this.getPlayer().getWorld().spawn(loc, Sheep.class);
        sheep.setNoDamageTicks(100000);
        this.sheeps.add(sheep);
        UltraCosmeticsData.get().getVersionManager().getEntityUtil().clearPathfinders((Entity)sheep);
        new SheepColorRunnable(sheep, 7.0, true);
    }

    @EventHandler
    public void onShear(PlayerShearEntityEvent event) {
        if (this.sheeps.contains(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (this.sheeps.contains(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @Override
    public void onClear() {
        for (Sheep sheep : this.sheeps) {
            sheep.remove();
        }
        if (this.sheepExplosionRunnable != null) {
            this.sheepExplosionRunnable.cancel();
        }
    }

    private class SheepColorRunnable
    extends BukkitRunnable {
        private final Sheep s;
        private boolean red;
        private double time;

        private SheepColorRunnable(Sheep s, double time, boolean red) {
            this.s = s;
            this.red = red;
            this.time = time;
            this.runTaskLater((Plugin)GadgetExplosiveSheep.this.getUltraCosmetics(), (int)time);
        }

        public void run() {
            if (GadgetExplosiveSheep.this.getOwner() == null || GadgetExplosiveSheep.this.getPlayer() == null || !this.s.isValid()) {
                this.cancel();
                return;
            }
            this.s.setColor(this.red ? DyeColor.RED : DyeColor.WHITE);
            GadgetExplosiveSheep.this.play(XSound.BLOCK_NOTE_BLOCK_HAT, this.s.getLocation(), 1.4f, 1.5f);
            this.red = !this.red;
            this.time -= 0.2;
            if (this.time >= 0.5) {
                new SheepColorRunnable(this.s, this.time, this.red);
                return;
            }
            GadgetExplosiveSheep.this.play(XSound.ENTITY_GENERIC_EXPLODE, this.s.getLocation(), 1.4f, 1.5f);
            Particles.EXPLOSION_HUGE.display(this.s.getLocation());
            GadgetExplosiveSheep.this.sheeps.remove(this.s);
            this.s.remove();
            DyeColor[] colors = DyeColor.values();
            final EntitySpawner<Sheep> sheeps = new EntitySpawner<Sheep>(EntityType.SHEEP, this.s.getLocation(), 50, sheep -> {
                sheep.setColor(colors[RANDOM.nextInt(colors.length)]);
                MathUtils.applyVelocity((Entity)sheep, new Vector(RANDOM.nextDouble() - 0.5, RANDOM.nextDouble() / 2.0, RANDOM.nextDouble() - 0.5).multiply(2).add(new Vector(0.0, 0.8, 0.0)));
                sheep.setBaby();
                sheep.setAgeLock(true);
                sheep.setNoDamageTicks(120);
                UltraCosmeticsData.get().getVersionManager().getEntityUtil().clearPathfinders((Entity)sheep);
                UltraCosmeticsData.get().getVersionManager().getEntityUtil().makePanic((Entity)sheep);
            }, GadgetExplosiveSheep.this.getUltraCosmetics());
            GadgetExplosiveSheep.this.sheepExplosionRunnable = new BukkitRunnable(){

                public void run() {
                    for (Sheep sheep : sheeps.getEntities()) {
                        Particles.LAVA.display(sheep.getLocation(), 5);
                    }
                    sheeps.removeEntities();
                }
            };
            GadgetExplosiveSheep.this.sheepExplosionRunnable.runTaskLater((Plugin)GadgetExplosiveSheep.this.getUltraCosmetics(), 110L);
        }
    }
}

