/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.ServerVersion;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.spigotmc.event.entity.EntityDismountEvent;

public class GadgetEtherealPearl
extends Gadget
implements Updatable {
    private EnderPearl pearl;
    private boolean running = false;
    private boolean handledThisTick = false;
    private Location lastLoc = null;

    public GadgetEtherealPearl(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void onClear() {
        if (this.pearl != null) {
            this.pearl.remove();
        }
    }

    @Override
    protected boolean checkRequirements(PlayerInteractEvent event) {
        if (this.handledThisTick) {
            return false;
        }
        this.handledThisTick = true;
        Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), () -> {
            this.handledThisTick = false;
        }, 1L);
        return true;
    }

    @Override
    protected void onRightClick() {
        this.getOwner().removeCosmetic(Category.MOUNTS);
        if (this.getPlayer().getVehicle() instanceof EnderPearl) {
            this.getPlayer().getVehicle().remove();
            this.getPlayer().eject();
        }
        this.pearl = (EnderPearl)this.getPlayer().launchProjectile(EnderPearl.class);
        this.pearl.setVelocity(this.getPlayer().getEyeLocation().getDirection().multiply(1.53));
        this.getPlayer().teleport(this.getPlayer().getLocation().add(0.0, 5.0, 0.0));
        if (!this.getPlayer().getAllowFlight()) {
            this.getPlayer().setAllowFlight(true);
        }
        this.pearl.setPassenger((Entity)this.getPlayer());
        this.running = true;
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (this.running && event.getCause() == EntityDamageEvent.DamageCause.FALL && event.getEntity() == this.getPlayer()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDismount(EntityDismountEvent event) {
        if (this.pearl == null) {
            return;
        }
        if (event.getEntity() != this.getPlayer()) {
            return;
        }
        if (UltraCosmeticsData.get().getServerVersion() == ServerVersion.v1_8) {
            Bukkit.getScheduler().runTask((Plugin)this.getUltraCosmetics(), this::endRide);
        } else {
            this.endRide();
        }
    }

    @EventHandler
    public void onItemFrameBreak(HangingBreakByEntityEvent event) {
        if (event.getRemover() == this.pearl) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onProjectileHit(ProjectileHitEvent event) {
        if (event.getEntity() == this.pearl || event.getEntity() == this.getPlayer()) {
            event.getEntity().remove();
            this.pearl = null;
        }
    }

    private void endRide() {
        if (this.getPlayer().getGameMode() != GameMode.CREATIVE) {
            this.getPlayer().setAllowFlight(false);
        }
        if (this.pearl != null) {
            this.pearl.remove();
            this.pearl = null;
        }
        if (this.lastLoc != null) {
            this.getPlayer().teleport(this.lastLoc.add(0.0, 1.0, 0.0));
        }
        this.spawnRandomFirework(this.getPlayer().getLocation(), Color.fromRGB((int)100, (int)0, (int)100), Color.fromRGB((int)30, (int)0, (int)30));
        this.running = false;
    }

    @Override
    public void onUpdate() {
        if (this.running && (this.pearl == null || !this.pearl.isValid())) {
            this.endRide();
        } else {
            this.lastLoc = this.getPlayer().getLocation();
        }
    }
}

