/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XMaterial;
import be.isach.ultracosmetics.shaded.xseries.XTag;
import be.isach.ultracosmetics.util.Area;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.Particles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GadgetDiscoBall
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private static final Set<GadgetDiscoBall> DISCO_BALLS = new HashSet<GadgetDiscoBall>();
    private int i = 0;
    private double i2 = 0.0;
    private ArmorStand armorStand;
    private boolean running = false;

    public GadgetDiscoBall(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.armorStand = (ArmorStand)this.getPlayer().getWorld().spawnEntity(this.getPlayer().getLocation().add(0.0, 3.0, 0.0), EntityType.ARMOR_STAND);
        this.armorStand.setMetadata("NO_INTER", (MetadataValue)new FixedMetadataValue((Plugin)this.getUltraCosmetics(), (Object)""));
        this.armorStand.setVisible(false);
        this.armorStand.setGravity(false);
        this.armorStand.setSmall(false);
        this.setHelmet(this.armorStand, ItemFactory.rename(XMaterial.LIGHT_BLUE_STAINED_GLASS.parseItem(), " "));
        this.running = true;
        DISCO_BALLS.add(this);
        Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), this::clean, 400L);
    }

    @Override
    protected boolean checkRequirements(PlayerInteractEvent event) {
        if (DISCO_BALLS.size() > 0) {
            this.getPlayer().sendMessage(MessageManager.getMessage("Gadgets.DiscoBall.Already-Active"));
            return false;
        }
        Area area = new Area(this.getPlayer().getLocation(), 0, 4);
        if (!area.isEmpty()) {
            this.getPlayer().sendMessage(MessageManager.getMessage("Gadgets.DiscoBall.Not-Space-Above"));
            return false;
        }
        return true;
    }

    @Override
    public void onUpdate() {
        if (this.armorStand == null) {
            return;
        }
        if (!this.armorStand.isValid() || !this.running) {
            this.i = 0;
            this.i2 = 0.0;
            this.clean();
            return;
        }
        this.armorStand.setHeadPose(this.armorStand.getHeadPose().add(0.0, 0.2, 0.0));
        this.setHelmet(this.armorStand, ItemFactory.getRandomStainedGlass());
        Particles.SPELL.display(this.armorStand.getEyeLocation(), 1, 1.0f);
        Particles.SPELL_INSTANT.display(this.armorStand.getEyeLocation(), 1, 1.0f);
        Location loc = this.armorStand.getEyeLocation().add(MathUtils.randomDouble(-4.0, 4.0), MathUtils.randomDouble(-3.0, 3.0), MathUtils.randomDouble(-4.0, 4.0));
        Particles.NOTE.display((Particles.ParticleColor)new Particles.NoteColor(RANDOM.nextInt(25)), loc, 128.0);
        double angle = Math.PI * 2 * (double)this.i / 100.0;
        double x = Math.cos(angle) * 4.0;
        double z = Math.sin(angle) * 4.0;
        this.drawParticleLine(this.armorStand.getEyeLocation().add(-0.5, -0.5, -0.5).clone().add(0.5, 0.5, 0.5).clone().add(x, 0.0, z), this.armorStand.getEyeLocation().add(-0.5, -0.5, -0.5).clone().add(0.5, 0.5, 0.5), false, 20);
        this.i += 6;
        double angle2 = Math.PI * 2 * this.i2 / 100.0;
        double x2 = Math.cos(angle2) * 4.0;
        double z2 = Math.sin(angle2) * 4.0;
        this.drawParticleLine(this.armorStand.getEyeLocation().add(-0.5, -0.5, -0.5).clone().add(0.5, 0.5, 0.5), this.armorStand.getEyeLocation().add(-0.5, -0.5, -0.5).clone().add(0.5, 0.5, 0.5).add(x2, 0.0, z2), true, 50);
        this.i2 += 0.4;
        XTag<XMaterial> tag = null;
        HashMap<Block, XMaterial> updates = new HashMap<Block, XMaterial>();
        for (Block b : BlockUtils.getBlocksInRadius(this.armorStand.getEyeLocation().add(-0.5, -0.5, -0.5), 10, false)) {
            XMaterial mat = XMaterial.matchXMaterial(b.getType());
            if (XTag.WOOL.isTagged(mat)) {
                tag = XTag.WOOL;
            } else if (XTag.CARPETS.isTagged(mat)) {
                tag = XTag.CARPETS;
            }
            if (tag == null) continue;
            updates.put(b, ItemFactory.randomFromTag(tag));
            tag = null;
        }
        BlockUtils.setToRestore(updates, 4);
        for (Entity ent : loc.getWorld().getNearbyEntities(this.armorStand.getEyeLocation().add(-0.5, -0.5, -0.5), 7.5, 7.5, 7.5)) {
            if (!ent.isOnGround() || !this.canAffect(ent)) continue;
            MathUtils.applyVelocity(ent, new Vector(0.0, 0.3, 0.0));
        }
    }

    private void clean() {
        this.running = false;
        if (this.armorStand != null) {
            this.armorStand.remove();
            this.armorStand = null;
        }
        DISCO_BALLS.remove(this);
    }

    @Override
    public void onClear() {
        this.clean();
    }

    public void drawParticleLine(Location a, Location b, boolean dust, int particles) {
        Location location = a.clone();
        Location target = b.clone();
        Vector link = target.toVector().subtract(location.toVector());
        float length = (float)link.length();
        link.normalize();
        float ratio = length / (float)particles;
        Vector v = link.multiply(ratio);
        if (!dust) {
            MathUtils.rotateAroundAxisX(v, this.i);
        } else {
            MathUtils.rotateAroundAxisZ(v, this.i2 / 5.0);
            MathUtils.rotateAroundAxisX(v, this.i2 / 5.0);
        }
        Location loc = location.clone().subtract(v);
        int step = 0;
        for (int i = 0; i < particles; ++i) {
            if ((double)step >= (double)particles) {
                step = 0;
            }
            ++step;
            loc.add(v);
            if (!dust) continue;
            Particles.REDSTONE.display(MathUtils.random(255), MathUtils.random(255), MathUtils.random(255), loc);
        }
    }

    private void setHelmet(ArmorStand stand, ItemStack itemStack) {
        stand.setHelmet(itemStack);
    }
}

