/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.shaded.xseries.XTag;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.Particles;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GadgetColorBomb
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private Item bomb;
    private ArrayList<Item> items = new ArrayList();
    private boolean running = false;

    public GadgetColorBomb(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.bomb = ItemFactory.createUnpickableItemDirectional(ItemFactory.randomFromTag(XTag.WOOL), this.getPlayer(), 0.7532);
    }

    @Override
    public void onUpdate() {
        Particles effect;
        if (this.bomb == null || !this.bomb.isValid()) {
            return;
        }
        if (!this.running && this.bomb.isOnGround()) {
            this.running = true;
            this.bomb.setVelocity(new Vector(0, 0, 0));
            Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), this::onClear, 100L);
        }
        if (!this.running) {
            return;
        }
        switch (RANDOM.nextInt(5)) {
            default: {
                effect = Particles.FIREWORKS_SPARK;
                break;
            }
            case 3: {
                effect = Particles.FLAME;
                break;
            }
            case 4: {
                effect = Particles.SPELL_WITCH;
            }
        }
        effect.display(this.bomb.getLocation(), 1, 0.2f);
        Iterator<Item> iter = this.items.iterator();
        while (iter.hasNext()) {
            Item item = iter.next();
            if (item.getTicksLived() <= 15) continue;
            item.remove();
            iter.remove();
        }
        Bukkit.getScheduler().runTask((Plugin)this.getUltraCosmetics(), () -> {
            if (this.bomb == null) {
                return;
            }
            Vector velocity = new Vector(0.0, 0.5, 0.0).add(MathUtils.getRandomCircleVector().multiply(0.1));
            Item item = ItemFactory.spawnUnpickableItem(ItemFactory.randomItemFromTag(XTag.WOOL), this.bomb.getLocation().add(0.0, 0.15, 0.0), velocity);
            this.items.add(item);
            this.play(XSound.ENTITY_CHICKEN_EGG, item.getLocation(), 0.2f, 1.0f);
            for (Entity entity : this.bomb.getNearbyEntities(1.5, 1.0, 1.5)) {
                if (!(entity instanceof Player) || !this.canAffect(entity)) continue;
                MathUtils.applyVelocity(entity, new Vector(0.0, 0.5, 0.0).add(MathUtils.getRandomCircleVector().multiply(0.1)));
            }
        });
    }

    @Override
    public void onClear() {
        if (this.bomb != null) {
            this.bomb.remove();
            this.bomb = null;
        }
        if (this.items != null) {
            for (Item item : this.items) {
                item.remove();
            }
            this.items.clear();
        }
        this.running = false;
    }
}

