/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.Particles;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GadgetChristmasTree
extends Gadget
implements Updatable {
    private boolean active = false;
    private Location lastLocation;
    private static final Color LOG_COLOR = Color.fromRGB((int)101, (int)67, (int)33);

    public GadgetChristmasTree(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void onRightClick() {
        this.lastLocation = this.lastClickedBlock.getLocation().add(0.5, 1.05, 0.5);
        this.active = true;
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)this.getUltraCosmetics(), () -> {
            this.active = false;
        }, 200L);
    }

    @Override
    public void onUpdate() {
        if (this.active) {
            this.drawLog();
            this.drawLeavesAndBalls();
            this.drawStar();
            this.drawSnow();
        }
    }

    private void drawSnow() {
        this.lastLocation.add(0.0, 3.0, 0.0);
        Particles.FIREWORKS_SPARK.display(4.0, 3.0, 4.0, this.lastLocation, 10);
        this.lastLocation.subtract(0.0, 3.0, 0.0);
    }

    @Override
    protected boolean checkRequirements(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            this.getPlayer().sendMessage(MessageManager.getMessage("Gadgets.ChristmasTree.Click-On-Block"));
            return false;
        }
        return true;
    }

    private void drawLog() {
        Location current = this.lastLocation.clone();
        Location to = this.lastLocation.clone().add(0.0, 2.5, 0.0);
        Vector link = to.toVector().subtract(current.toVector());
        float length = (float)link.length();
        link.normalize();
        float ratio = length / 10.0f;
        Vector vector = link.multiply(ratio);
        for (int i = 0; i < 10; ++i) {
            Particles.REDSTONE.display(LOG_COLOR.getRed(), LOG_COLOR.getGreen(), LOG_COLOR.getBlue(), current);
            current.add(vector);
        }
    }

    private void drawLeavesAndBalls() {
        float radius = 0.7f;
        for (float f = 0.8f; f <= 2.5f; f += 0.2f) {
            if (!(radius >= 0.0f)) continue;
            float d = 13.0f / f;
            float g = MathUtils.random(d);
            int e = RANDOM.nextInt(2);
            if (e == 1) {
                double inc = Math.PI * 2 / (double)d;
                float angle = (float)((double)g * inc);
                float x = MathUtils.cos(angle) * (radius + 0.05f);
                float z = MathUtils.sin(angle) * (radius + 0.05f);
                this.lastLocation.add((double)x, (double)f, (double)z);
                Particles.REDSTONE.display(RANDOM.nextInt(256), RANDOM.nextInt(256), RANDOM.nextInt(256), this.lastLocation);
                this.lastLocation.subtract((double)x, (double)f, (double)z);
            }
            int i = 0;
            while ((float)i < d) {
                double inc = Math.PI * 2 / (double)d;
                float angle = (float)((double)i * inc);
                float x = MathUtils.cos(angle) * radius;
                float z = MathUtils.sin(angle) * radius;
                this.lastLocation.add((double)x, (double)f, (double)z);
                Particles.REDSTONE.display(0, 100, 0, this.lastLocation);
                this.lastLocation.subtract((double)x, (double)f, (double)z);
                ++i;
            }
            radius -= 0.082352936f;
        }
    }

    private void drawStar() {
        this.lastLocation.add(0.0, 2.6, 0.0);
        Particles.REDSTONE.display(255, 255, 0, this.lastLocation);
        this.lastLocation.subtract(0.0, 2.6, 0.0);
    }

    @Override
    public void onClear() {
        this.active = false;
        this.lastLocation = null;
    }
}

