/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.BlockUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GadgetBlizzardBlaster
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private boolean active;
    private Location location;
    private Vector vector;

    public GadgetBlizzardBlaster(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.vector = this.getPlayer().getLocation().getDirection().normalize().multiply(0.3);
        this.vector.setY(0);
        this.location = this.getPlayer().getLocation().subtract(0.0, 1.0, 0.0).add(this.vector);
        this.active = true;
        Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), () -> {
            this.active = false;
        }, 40L);
    }

    @Override
    public void onUpdate() {
        if (this.active) {
            if (this.location.getBlock().getType().isSolid()) {
                this.location.add(0.0, 1.0, 0.0);
            }
            if (BlockUtils.isAir(this.location.clone().subtract(0.0, 1.0, 0.0).getBlock().getType()) && !this.location.clone().getBlock().getType().toString().contains("SLAB")) {
                this.location.add(0.0, -1.0, 0.0);
            }
            for (int i = 0; i < 3; ++i) {
                UltraCosmeticsData.get().getVersionManager().getEntityUtil().sendBlizzard(this.getPlayer(), this.location, this::canAffect, this.vector);
            }
            this.location.add(this.vector);
        } else {
            this.location = null;
            this.vector = null;
        }
    }

    @Override
    public void onClear() {
        if (this.getOwner() == null || this.getPlayer() == null) {
            return;
        }
        UltraCosmeticsData.get().getVersionManager().getEntityUtil().clearBlizzard(this.getPlayer());
    }
}

