/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.util.EntitySpawner;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.Particles;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class GadgetBatBlaster
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private boolean active = false;
    private Location playerStartLoc;
    private EntitySpawner<Bat> bats;

    public GadgetBatBlaster(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.active = true;
        this.playerStartLoc = this.getPlayer().getEyeLocation();
        this.bats = new EntitySpawner(EntityType.BAT, this.getPlayer().getEyeLocation(), 16, this.getUltraCosmetics());
        Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), this::clean, 60L);
    }

    public boolean hitPlayer(Location location, Player player) {
        Vector playerVec;
        Vector locVec = location.add(0.0, -location.getY(), 0.0).toVector();
        double vecLength = locVec.subtract(playerVec = player.getLocation().add(0.0, -player.getLocation().getY(), 0.0).toVector()).length();
        if (vecLength < 0.8) {
            return true;
        }
        if (vecLength < 1.2) {
            return location.getY() > player.getLocation().getY() && location.getY() < player.getEyeLocation().getY();
        }
        return false;
    }

    @Override
    public void onUpdate() {
        if (this.bats == null || this.bats.isEmpty()) {
            return;
        }
        if (!this.active) {
            this.clean();
            return;
        }
        Iterator<Bat> iter = this.bats.getEntities().iterator();
        block0: while (iter.hasNext()) {
            Bat bat = iter.next();
            if (!bat.isValid()) continue;
            Vector rand = new Vector((Math.random() - 0.5) / 3.0, (Math.random() - 0.5) / 3.0, (Math.random() - 0.5) / 3.0);
            if (this.playerStartLoc != null) {
                bat.setVelocity(this.playerStartLoc.getDirection().clone().multiply(0.5).add(rand));
            }
            for (Player other : this.getPlayer().getWorld().getPlayers()) {
                if (other == this.getPlayer() || !this.canAffect((Entity)other) || !this.hitPlayer(bat.getLocation(), other)) continue;
                Vector v = bat.getLocation().getDirection();
                v.normalize();
                v.multiply(0.4);
                v.setY(v.getY() + 0.2);
                if (v.getY() > 7.5) {
                    v.setY(7.5);
                }
                if (other.isOnGround()) {
                    v.setY(v.getY() + 0.4);
                }
                other.setFallDistance(0.0f);
                MathUtils.applyVelocity((Entity)other, bat.getLocation().getDirection().add(new Vector(0.0f, 0.4f, 0.0f)));
                this.play(XSound.ENTITY_BAT_HURT, bat.getLocation(), 1.0f, 1.0f);
                Particles.SMOKE_NORMAL.display(bat.getLocation());
                bat.remove();
                iter.remove();
                continue block0;
            }
        }
    }

    private void clean() {
        this.active = false;
        this.playerStartLoc = null;
        if (this.bats != null) {
            this.bats.removeEntities();
        }
    }

    @Override
    public void onClear() {
        this.clean();
    }
}

