/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.cosmetics.PlayerAffectingCosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.gadgets.Gadget;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.MathUtils;
import be.isach.ultracosmetics.util.Particles;
import be.isach.ultracosmetics.util.ServerVersion;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class GadgetAntiGravity
extends Gadget
implements PlayerAffectingCosmetic,
Updatable {
    private static final boolean USE_LEVITATION = UltraCosmeticsData.get().getServerVersion().isAtLeast(ServerVersion.v1_9);
    private ArmorStand as;
    private boolean running;

    public GadgetAntiGravity(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    protected void onRightClick() {
        this.as = (ArmorStand)this.getPlayer().getWorld().spawn(this.getPlayer().getLocation(), ArmorStand.class);
        this.as.setMetadata("NO_INTER", (MetadataValue)new FixedMetadataValue((Plugin)this.getUltraCosmetics(), (Object)""));
        this.as.setGravity(false);
        this.as.setSmall(true);
        this.running = true;
        this.as.setVisible(false);
        this.as.setHelmet(new ItemStack(Material.SEA_LANTERN));
        Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), () -> {
            this.running = false;
        }, 240L);
    }

    @Override
    public void onUpdate() {
        if (this.as == null || !this.as.isValid()) {
            return;
        }
        if (!this.running) {
            this.as.remove();
            this.as = null;
            return;
        }
        this.as.setHeadPose(this.as.getHeadPose().add(0.0, 0.1, 0.0));
        Particles.PORTAL.display(3.0, 3.0, 3.0, this.as.getLocation(), 150);
        Particles.SPELL_WITCH.display(0.3f, (double)0.3f, (double)0.3f, this.as.getEyeLocation(), 5);
        for (Entity ent : this.as.getNearbyEntities(3.0, 2.0, 3.0)) {
            if (!this.canAffect(ent)) continue;
            LivingEntity le = (LivingEntity)ent;
            if (USE_LEVITATION) {
                le.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 5, 0));
                continue;
            }
            MathUtils.applyVelocity(ent, new Vector(0.0, 0.05, 0.0));
        }
    }

    @EventHandler
    public void onKick(PlayerKickEvent event) {
        if (!this.running || !USE_LEVITATION) {
            return;
        }
        if (this.as != null && this.as.isValid() && event.getReason().equals("Flying is not enabled on this server") && this.as.getLocation().distanceSquared(event.getPlayer().getLocation()) < 6.0) {
            event.setCancelled(true);
            this.getUltraCosmetics().getSmartLogger().write("UltraCosmetics >> Cancelling flight kick while using antigravity.");
            return;
        }
    }

    @Override
    public void onClear() {
        if (this.as != null) {
            this.as.remove();
        }
        this.running = false;
    }
}

