/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.gadgets;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.shaded.xseries.XSound;
import be.isach.ultracosmetics.shaded.xseries.messages.ActionBar;
import be.isach.ultracosmetics.util.ItemFactory;
import be.isach.ultracosmetics.util.TextUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;

public abstract class Gadget
extends Cosmetic<GadgetType> {
    private static final DecimalFormatSymbols OTHER_SYMBOLS = new DecimalFormatSymbols(Locale.US);
    private static final DecimalFormat DECIMAL_FORMAT;
    protected ItemStack itemStack;
    protected boolean displayCooldownMessage = true;
    protected Block lastClickedBlock;
    private boolean asynchronous = false;
    private final Material material;

    public Gadget(UltraPlayer owner, GadgetType type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
        this.material = type.getMaterial().parseMaterial();
    }

    @Override
    protected void onEquip() {
        int slot = SettingsManager.getConfig().getInt("Gadget-Slot");
        if (this.getPlayer().getInventory().getItem(slot) != null) {
            this.getPlayer().getWorld().dropItem(this.getPlayer().getLocation(), this.getPlayer().getInventory().getItem(slot));
            this.getPlayer().getInventory().setItem(slot, null);
        }
        String ammo = "";
        if (UltraCosmeticsData.get().isAmmoEnabled() && ((GadgetType)this.getType()).requiresAmmo()) {
            ammo = ChatColor.WHITE + "" + ChatColor.BOLD + this.getOwner().getAmmo((GadgetType)this.getType()) + " ";
        }
        this.itemStack = ItemFactory.create(((GadgetType)this.getType()).getMaterial(), ammo + ((GadgetType)this.getType()).getName(), MessageManager.getMessage("Gadgets.Lore"));
        this.getPlayer().getInventory().setItem(((Integer)SettingsManager.getConfig().get("Gadget-Slot")).intValue(), this.itemStack);
    }

    @Override
    public void run() {
        if (this.getOwner() == null || this.getPlayer() == null) {
            return;
        }
        if (this.getOwner().getCurrentGadget() != null && this.getOwner().getCurrentGadget().getType() == this.getType()) {
            String leftRounded;
            double decimalRoundedValue;
            ((Updatable)((Object)this)).onUpdate();
            try {
                ItemStack hand;
                if (UltraCosmeticsData.get().displaysCooldownInBar() && (hand = this.getPlayer().getItemInHand()) != null && this.itemStack != null && hand.hasItemMeta() && hand.getType() == this.getItemStack().getType() && hand.getItemMeta().hasDisplayName() && hand.getItemMeta().getDisplayName().endsWith(((GadgetType)this.getType()).getName()) && !this.getUltraCosmetics().getPlayerManager().getUltraPlayer(this.getPlayer()).canUse((GadgetType)this.getType())) {
                    this.sendCooldownBar();
                }
            }
            catch (NullPointerException hand) {
                // empty catch block
            }
            if (this.getOwner() == null || this.getPlayer() == null) {
                return;
            }
            double left = this.getUltraCosmetics().getPlayerManager().getUltraPlayer(this.getPlayer()).getCooldown((GadgetType)this.getType());
            if (left > 0.0 && (decimalRoundedValue = Double.parseDouble(leftRounded = DECIMAL_FORMAT.format(left))) == 0.0) {
                String message = MessageManager.getMessage("Gadgets.Gadget-Ready-ActionBar");
                message = message.replace("%gadgetname%", TextUtil.filterPlaceHolder(((GadgetType)this.getType()).getName()));
                ActionBar.sendActionBar(this.getPlayer(), message);
                this.play(XSound.BLOCK_NOTE_BLOCK_HAT, (Entity)this.getPlayer(), 1.4f, 1.5f);
            }
        } else {
            this.clear();
        }
    }

    @Override
    public void clear() {
        this.removeItem();
        super.clear();
    }

    private void sendCooldownBar() {
        if (this.getOwner() == null || this.getPlayer() == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(ChatColor.GREEN.toString());
        double currentCooldown = this.getUltraCosmetics().getPlayerManager().getUltraPlayer(this.getPlayer()).getCooldown((GadgetType)this.getType());
        double maxCooldown = this.getOwner().isBypassingCooldown() ? (double)((GadgetType)this.getType()).getRunTime() : ((GadgetType)this.getType()).getCountdown();
        int res = (int)(currentCooldown / maxCooldown * 50.0);
        for (int i = 0; i < 50; ++i) {
            if (i == 50 - res) {
                stringBuilder.append(ChatColor.RED);
            }
            stringBuilder.append("|");
        }
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.US);
        otherSymbols.setDecimalSeparator('.');
        otherSymbols.setGroupingSeparator('.');
        otherSymbols.setPatternSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("0.0", otherSymbols);
        String timeLeft = decimalFormat.format(currentCooldown) + "s";
        ActionBar.sendActionBar(this.getPlayer(), ((GadgetType)this.getType()).getName() + ChatColor.WHITE + " " + stringBuilder.toString() + ChatColor.WHITE + " " + timeLeft);
    }

    public void removeItem() {
        this.itemStack = null;
        this.getPlayer().getInventory().setItem(((Integer)SettingsManager.getConfig().get("Gadget-Slot")).intValue(), null);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    protected boolean checkRequirements(PlayerInteractEvent event) {
        return true;
    }

    protected void play(XSound sound, Entity entity, float volume, float pitch) {
        if (!SettingsManager.getConfig().getBoolean("Gadgets-Are-Silent")) {
            sound.play(entity, volume, pitch);
        }
    }

    protected void play(XSound sound, Location loc, float volume, float pitch) {
        if (!SettingsManager.getConfig().getBoolean("Gadgets-Are-Silent")) {
            sound.play(loc, volume, pitch);
        }
    }

    public static FireworkEffect getRandomFireworkEffect(Color main, Color fade) {
        FireworkEffect.Builder builder = FireworkEffect.builder();
        return builder.flicker(false).trail(false).with(FireworkEffect.Type.BALL_LARGE).withColor(main).withFade(fade).build();
    }

    public void spawnRandomFirework(Location location, Color main, Color fade) {
        HashSet fireworks = new HashSet();
        for (int i = 0; i < 4; ++i) {
            Firework f = (Firework)location.getWorld().spawnEntity(location, EntityType.FIREWORK);
            FireworkMeta fm = f.getFireworkMeta();
            fm.addEffect(Gadget.getRandomFireworkEffect(main, fade));
            fm.setDisplayName("uc_firework");
            f.setFireworkMeta(fm);
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.getUltraCosmetics(), () -> {
            for (Firework f : fireworks) {
                f.detonate();
            }
        }, 2L);
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!(this.getOwner() != null && this.getPlayer() != null && event.getPlayer() == this.getPlayer() && event.getRightClicked() instanceof ItemFrame && this.getItemStack() != null && this.itemStack != null && this.itemStack.hasItemMeta() && this.itemStack.getType() == this.getItemStack().getType() && this.itemStack.getItemMeta().getDisplayName().endsWith(((GadgetType)this.getType()).getName()))) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.PHYSICAL) {
            return;
        }
        Player player = event.getPlayer();
        if (player != this.getPlayer()) {
            return;
        }
        ItemStack itemStack = player.getItemInHand();
        if (itemStack.getType() != this.material) {
            return;
        }
        if (player.getInventory().getHeldItemSlot() != SettingsManager.getConfig().getInt("Gadget-Slot")) {
            return;
        }
        if (UltraCosmeticsData.get().getServerVersion().offhandAvailable() && event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        event.setCancelled(true);
        UltraPlayer ultraPlayer = this.getUltraCosmetics().getPlayerManager().getUltraPlayer(event.getPlayer());
        if (ultraPlayer.getCurrentTreasureChest() != null) {
            return;
        }
        if (player.hasMetadata("vanished") && SettingsManager.getConfig().getBoolean("Prevent-Cosmetics-In-Vanish")) {
            this.getOwner().clear();
            this.getPlayer().sendMessage(MessageManager.getMessage("Not-Allowed-In-Vanish"));
            return;
        }
        if (!ultraPlayer.hasGadgetsEnabled()) {
            this.getPlayer().sendMessage(MessageManager.getMessage("Gadgets-Enabled-Needed"));
            return;
        }
        if (UltraCosmeticsData.get().isAmmoEnabled() && ((GadgetType)this.getType()).requiresAmmo() && ultraPlayer.getAmmo((GadgetType)this.getType()) < 1) {
            UltraCosmeticsData.get().getPlugin().getMenus().openAmmoPurchaseMenu((GadgetType)this.getType(), this.getOwner());
            return;
        }
        if (!this.checkRequirements(event)) {
            return;
        }
        double coolDown = ultraPlayer.getCooldown((GadgetType)this.getType());
        if (coolDown > 0.0) {
            String timeLeft = new DecimalFormat("#.#").format(coolDown);
            if (((GadgetType)this.getType()).getCountdown() > 1.0) {
                this.getPlayer().sendMessage(MessageManager.getMessage("Gadgets.Countdown-Message").replace("%gadgetname%", TextUtil.filterPlaceHolder(((GadgetType)this.getType()).getName())).replace("%time%", timeLeft));
            }
            return;
        }
        ultraPlayer.setCoolDown((GadgetType)this.getType());
        if (UltraCosmeticsData.get().isAmmoEnabled() && ((GadgetType)this.getType()).requiresAmmo()) {
            ultraPlayer.removeAmmo((GadgetType)this.getType());
            this.itemStack = itemStack = ItemFactory.create(((GadgetType)this.getType()).getMaterial(), ChatColor.WHITE + "" + ChatColor.BOLD + ultraPlayer.getAmmo((GadgetType)this.getType()) + " " + ((GadgetType)this.getType()).getName(), MessageManager.getMessage("Gadgets.Lore"));
            this.getPlayer().getInventory().setItem(((Integer)SettingsManager.getConfig().get("Gadget-Slot")).intValue(), itemStack);
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            this.lastClickedBlock = event.getClickedBlock();
        }
        boolean isLeft = event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK;
        Runnable callClick = () -> {
            if (isLeft) {
                this.onLeftClick();
            } else {
                this.onRightClick();
            }
        };
        if (this.asynchronous) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.getUltraCosmetics(), callClick);
        } else {
            callClick.run();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemDrop(PlayerDropItemEvent event) {
        if (event.getItemDrop().getItemStack().equals((Object)this.getItemStack())) {
            if (SettingsManager.getConfig().getBoolean("Remove-Gadget-With-Drop")) {
                this.clear();
                event.getItemDrop().remove();
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void cancelMove(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (player != this.getPlayer()) {
            return;
        }
        if (event.getCurrentItem() != null && event.getCurrentItem().equals((Object)this.getItemStack()) || event.getClick() == ClickType.NUMBER_KEY && this.getItemStack().equals((Object)player.getInventory().getItem(event.getHotbarButton()))) {
            event.setCancelled(true);
            player.updateInventory();
        }
    }

    @EventHandler
    public void cancelMove(InventoryDragEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (player != this.getPlayer()) {
            return;
        }
        for (ItemStack item : event.getNewItems().values()) {
            if (item == null || !item.equals((Object)this.itemStack)) continue;
            event.setCancelled(true);
            player.updateInventory();
            player.closeInventory();
            return;
        }
    }

    @EventHandler
    public void cancelMove(InventoryCreativeEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack item = event.getCurrentItem();
        if (item != null && player == this.getPlayer() && item.equals((Object)this.itemStack)) {
            event.setCancelled(true);
            player.closeInventory();
        }
    }

    protected void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    protected abstract void onRightClick();

    protected void onLeftClick() {
        this.onRightClick();
    }

    static {
        OTHER_SYMBOLS.setDecimalSeparator('.');
        OTHER_SYMBOLS.setGroupingSeparator('.');
        OTHER_SYMBOLS.setPatternSeparator('.');
        DECIMAL_FORMAT = new DecimalFormat("0.0", OTHER_SYMBOLS);
    }
}

