/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics.emotes;

import be.isach.ultracosmetics.cosmetics.emotes.Emote;
import be.isach.ultracosmetics.cosmetics.type.EmoteType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

class EmoteAnimation
extends BukkitRunnable {
    private static final int INTERVAL_BETWEEN_REPLAY = 20;
    private int ticks;
    private int ticksPerFrame;
    private int currentFrame;
    private int intervalTick;
    private Emote emote;
    private boolean running;
    private boolean up = true;

    EmoteAnimation(int ticksPerFrame, Emote emote) {
        this.ticksPerFrame = ticksPerFrame;
        this.emote = emote;
        this.ticks = 0;
        this.running = false;
    }

    public void run() {
        if (this.ticks < this.ticksPerFrame) {
            ++this.ticks;
        } else {
            this.ticks = 0;
            this.updateTexture();
        }
    }

    void start() {
        this.running = true;
        this.runTaskTimer((Plugin)this.emote.getUltraCosmetics(), 0L, this.ticksPerFrame);
    }

    void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            this.cancel();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void updateTexture() {
        if (!this.running) {
            return;
        }
        this.emote.getPlayer().getInventory().setHelmet(((EmoteType)this.emote.getType()).getFrames().get(this.currentFrame));
        this.emote.setItemStack(((EmoteType)this.emote.getType()).getFrames().get(this.currentFrame));
        if (this.up) {
            if (this.currentFrame >= ((EmoteType)this.emote.getType()).getMaxFrames() - 1) {
                this.up = false;
            } else {
                ++this.currentFrame;
            }
        } else if (this.currentFrame <= 0) {
            if (this.intervalTick >= 20 / this.ticksPerFrame) {
                this.up = true;
                this.intervalTick = 0;
            } else {
                ++this.intervalTick;
            }
        } else {
            --this.currentFrame;
        }
    }
}

