/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics;

import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public interface PlayerAffectingCosmetic {
    default public boolean canAffect(Entity entity) {
        if (!this.isAffectingPlayersEnabled()) {
            return false;
        }
        if (entity.hasMetadata("NPC") || entity.hasMetadata("Pet") || entity.hasMetadata("Mount")) {
            return false;
        }
        if (entity instanceof Player) {
            Player target = (Player)entity;
            if (Bukkit.getPlayer((UUID)target.getUniqueId()) == null) {
                return false;
            }
            if (target.hasMetadata("vanished")) {
                return false;
            }
            if (!this.getSelf().getUltraCosmetics().getPlayerManager().getUltraPlayer(target).hasGadgetsEnabled()) {
                return false;
            }
            if (!this.getSelf().getUltraCosmetics().arePlayersAffectedInRegion(target)) {
                return false;
            }
        } else if (!(entity instanceof Creature)) {
            return false;
        }
        return true;
    }

    default public boolean isAffectingPlayersEnabled() {
        Object type = this.getSelf().getType();
        return SettingsManager.getConfig().getBoolean(((CosmeticType)type).getCategory().getConfigPath() + "." + ((CosmeticType)type).getConfigName() + ".Affect-Players");
    }

    default public Cosmetic<?> getSelf() {
        return (Cosmetic)((Object)this);
    }
}

