/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Updatable;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.util.TextUtil;
import be.isach.ultracosmetics.worldguard.CosmeticRegionState;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Cosmetic<T extends CosmeticType<?>>
extends BukkitRunnable
implements Listener {
    protected static final Random RANDOM = new Random();
    private final UltraPlayer owner;
    private final Category category;
    private final UltraCosmetics ultraCosmetics;
    protected boolean equipped;
    protected final T cosmeticType;
    private final UUID ownerUniqueId;

    public Cosmetic(UltraPlayer owner, T type, UltraCosmetics ultraCosmetics) {
        if (owner == null || Bukkit.getPlayer((UUID)owner.getUUID()) == null) {
            throw new IllegalArgumentException("Invalid UltraPlayer.");
        }
        this.owner = owner;
        this.ownerUniqueId = owner.getUUID();
        this.category = ((CosmeticType)type).getCategory();
        this.ultraCosmetics = ultraCosmetics;
        this.cosmeticType = type;
    }

    public final void equip() {
        if (!this.owner.getBukkitPlayer().hasPermission(((CosmeticType)this.getType()).getPermission())) {
            this.getPlayer().sendMessage(MessageManager.getMessage("No-Permission"));
            return;
        }
        if (SettingsManager.getConfig().getBoolean("Prevent-Cosmetics-In-Vanish")) {
            this.owner.clear();
            this.getPlayer().sendMessage(MessageManager.getMessage("Not-Allowed-In-Vanish"));
            return;
        }
        CosmeticRegionState state = this.ultraCosmetics.cosmeticRegionState(this.getPlayer(), this.category);
        if (state == CosmeticRegionState.BLOCKED_ALL) {
            this.getPlayer().sendMessage(MessageManager.getMessage("Region-Disabled"));
            return;
        }
        if (state == CosmeticRegionState.BLOCKED_CATEGORY) {
            this.getPlayer().sendMessage(MessageManager.getMessage("Region-Disabled-Category").replace("%category%", ChatColor.stripColor((String)MessageManager.getMessage("Menu." + this.category.getMessagesName() + ".Title"))));
            return;
        }
        if (!this.tryEquip()) {
            return;
        }
        this.ultraCosmetics.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.ultraCosmetics);
        this.unequipLikeCosmetics();
        this.equipped = true;
        this.getPlayer().sendMessage(this.filterPlaceholders(this.getCategory().getActivateMessage()));
        if (this instanceof Updatable) {
            this.scheduleTask();
        }
        this.onEquip();
        this.getOwner().setCosmeticEquipped(this);
    }

    public void clear() {
        this.getPlayer().sendMessage(this.filterPlaceholders(this.getCategory().getDeactivateMessage()));
        HandlerList.unregisterAll((Listener)this);
        try {
            this.cancel();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.onClear();
        this.unsetCosmetic();
    }

    protected void scheduleTask() {
        this.runTaskTimer((Plugin)this.getUltraCosmetics(), 0L, 1L);
    }

    protected void unsetCosmetic() {
        this.owner.unsetCosmetic(this.category);
    }

    protected void unequipLikeCosmetics() {
        this.getOwner().removeCosmetic(this.category);
    }

    protected boolean tryEquip() {
        return true;
    }

    public void run() {
        if (this.getPlayer() == null || this.getOwner().getCosmetic(this.category) != this) {
            return;
        }
        ((Updatable)((Object)this)).onUpdate();
    }

    protected abstract void onEquip();

    protected void onClear() {
    }

    public final UltraPlayer getOwner() {
        return this.owner;
    }

    public final UltraCosmetics getUltraCosmetics() {
        return this.ultraCosmetics;
    }

    public final Category getCategory() {
        return this.category;
    }

    public final Player getPlayer() {
        return this.owner.getBukkitPlayer();
    }

    public boolean isEquipped() {
        return this.equipped;
    }

    public final UUID getOwnerUniqueId() {
        return this.ownerUniqueId;
    }

    public T getType() {
        return this.cosmeticType;
    }

    protected String getTypeName() {
        return ((CosmeticType)this.getType()).getName();
    }

    protected String filterPlaceholders(String message) {
        return message.replace(this.getCategory().getChatPlaceholder(), TextUtil.filterPlaceHolder(this.getTypeName()));
    }
}

