/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.EmoteType;
import be.isach.ultracosmetics.cosmetics.type.GadgetType;
import be.isach.ultracosmetics.cosmetics.type.HatType;
import be.isach.ultracosmetics.cosmetics.type.MorphType;
import be.isach.ultracosmetics.cosmetics.type.MountType;
import be.isach.ultracosmetics.cosmetics.type.ParticleEffectType;
import be.isach.ultracosmetics.cosmetics.type.PetType;
import be.isach.ultracosmetics.cosmetics.type.SuitCategory;
import be.isach.ultracosmetics.cosmetics.type.SuitType;
import be.isach.ultracosmetics.util.ItemFactory;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public enum Category {
    PETS("Pets", "%petname%", "pets", "pe", () -> PetType.enabled(), () -> UltraCosmeticsData.get().getServerVersion().isNmsSupported()),
    GADGETS("Gadgets", "%gadgetname%", "gadgets", "g", () -> GadgetType.enabled()),
    EFFECTS("Particle-Effects", "%effectname%", "particleeffects", "ef", () -> ParticleEffectType.enabled()),
    MOUNTS("Mounts", "%mountname%", "mounts", "mou", () -> MountType.enabled()),
    MORPHS("Morphs", "%morphname%", "morphs", "mor", () -> MorphType.enabled(), () -> Bukkit.getPluginManager().isPluginEnabled("LibsDisguises")),
    HATS("Hats", "%hatname%", "hats", "h", () -> HatType.enabled()),
    SUITS("Suits", "%suitname%", "suits", "s", () -> SuitType.enabled()),
    EMOTES("Emotes", "%emotename%", "emotes", "e", () -> EmoteType.enabled());

    private final String configPath;
    private final String chatPlaceholder;
    private final String permission;
    private final String prefix;
    private final Supplier<List<? extends CosmeticType<?>>> enabledFunc;
    private final Supplier<Boolean> enableCondition;

    public static int enabledSize() {
        return Category.enabled().size();
    }

    public static List<Category> enabled() {
        return Arrays.stream(Category.values()).filter(Category::isEnabled).collect(Collectors.toList());
    }

    public static Category fromString(String name) {
        String lowerName = name.toLowerCase();
        for (Category cat : Category.values()) {
            if (!lowerName.startsWith(cat.prefix)) continue;
            return cat;
        }
        return null;
    }

    public CosmeticType<?> valueOfType(String name) {
        if (name == null) {
            return null;
        }
        switch (this) {
            case EFFECTS: {
                return ParticleEffectType.valueOf(name);
            }
            case EMOTES: {
                return EmoteType.valueOf(name);
            }
            case GADGETS: {
                return GadgetType.valueOf(name);
            }
            case HATS: {
                return HatType.valueOf(name);
            }
            case MORPHS: {
                return MorphType.valueOf(name);
            }
            case MOUNTS: {
                return MountType.valueOf(name);
            }
            case PETS: {
                return PetType.valueOf(name);
            }
            case SUITS: {
                return SuitCategory.valueOf(name).getHelmet();
            }
        }
        return null;
    }

    private Category(String configPath, String chatPlaceholder, String permission, String prefix, Supplier<List<? extends CosmeticType<?>>> enabledFunc, Supplier<Boolean> enableCondition) {
        this.configPath = configPath;
        this.chatPlaceholder = chatPlaceholder;
        this.permission = permission;
        this.prefix = prefix;
        this.enabledFunc = enabledFunc;
        this.enableCondition = enableCondition;
    }

    private Category(String configPath, String chatPlaceholder, String permission, String prefix, Supplier<List<? extends CosmeticType<?>>> enabledFunc) {
        this(configPath, chatPlaceholder, permission, prefix, enabledFunc, () -> true);
    }

    public ItemStack getItemStack() {
        ItemStack is = SettingsManager.getConfig().contains("Categories." + this.configPath + ".Main-Menu-Item") ? ItemFactory.getItemStackFromConfig("Categories." + this.configPath + ".Main-Menu-Item") : ItemFactory.createSkull("5059d59eb4e59c31eecf9ece2f9cf3934e45c0ec476fc86bfaef8ea913ea710", "");
        ItemMeta itemMeta = is.getItemMeta();
        itemMeta.setDisplayName(MessageManager.getMessage("Menu." + this.configPath + ".Button.Name"));
        is.setItemMeta(itemMeta);
        return is;
    }

    public boolean isEnabled() {
        return this.enableCondition.get() != false && SettingsManager.getConfig().getBoolean("Categories-Enabled." + this.configPath);
    }

    public boolean hasGoBackArrow() {
        return (UltraCosmeticsData.get().areTreasureChestsEnabled() || Category.enabledSize() != 1) && SettingsManager.getConfig().getBoolean("Categories." + this.configPath + ".Go-Back-Arrow");
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getMessagesName() {
        return this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
    }

    public String getActivateTooltip() {
        return MessageManager.getMessage("Menu." + this.configPath + ".Button.Tooltip-Equip");
    }

    public String getDeactivateTooltip() {
        return MessageManager.getMessage("Menu." + this.configPath + ".Button.Tooltip-Unequip");
    }

    public String getChatPlaceholder() {
        return this.chatPlaceholder;
    }

    public String getPermission() {
        return "ultracosmetics." + this.permission;
    }

    public String getActivateMessage() {
        return MessageManager.getMessage(this.configPath + ".Equip");
    }

    public String getDeactivateMessage() {
        return MessageManager.getMessage(this.configPath + ".Unequip");
    }

    public List<? extends CosmeticType<?>> getEnabled() {
        return this.enabledFunc.get();
    }
}

