/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.cosmetics;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.Cosmetic;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.player.UltraPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;

public abstract class ArmorCosmetic<T extends CosmeticType<?>>
extends Cosmetic<T> {
    protected boolean success = false;
    protected ItemStack itemStack;

    public ArmorCosmetic(UltraPlayer owner, T type, UltraCosmetics ultraCosmetics) {
        super(owner, type, ultraCosmetics);
    }

    @Override
    public void clear() {
        super.clear();
        this.setArmorItem(null);
    }

    @Override
    protected boolean tryEquip() {
        return this.trySetSlot();
    }

    protected boolean trySetSlot() {
        this.getOwner().removeSuit(this.getArmorSlot());
        if (this.getArmorSlot() == ArmorSlot.HELMET) {
            this.getOwner().removeCosmetic(Category.HATS);
            this.getOwner().removeCosmetic(Category.EMOTES);
        }
        if (this.getArmorItem() != null) {
            this.getOwner().sendMessage(MessageManager.getMessage(this.getOccupiedSlotKey()));
            return false;
        }
        this.setArmorItem(this.itemStack);
        this.success = true;
        return true;
    }

    protected ItemStack getArmorItem() {
        switch (this.getArmorSlot()) {
            case BOOTS: {
                return this.getPlayer().getInventory().getBoots();
            }
            case LEGGINGS: {
                return this.getPlayer().getInventory().getLeggings();
            }
            case CHESTPLATE: {
                return this.getPlayer().getInventory().getChestplate();
            }
            case HELMET: {
                return this.getPlayer().getInventory().getHelmet();
            }
        }
        return null;
    }

    protected void setArmorItem(ItemStack item) {
        switch (this.getArmorSlot()) {
            case BOOTS: {
                this.getPlayer().getInventory().setBoots(item);
                break;
            }
            case LEGGINGS: {
                this.getPlayer().getInventory().setLeggings(item);
                break;
            }
            case CHESTPLATE: {
                this.getPlayer().getInventory().setChestplate(item);
                break;
            }
            case HELMET: {
                this.getPlayer().getInventory().setHelmet(item);
            }
        }
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        this.handleClick(event);
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        if (this.getOwner() == null || this.getPlayer() == null) {
            return;
        }
        if (event.getPlayer() == this.getPlayer() && this.isItemThis(event.getItemDrop().getItemStack())) {
            event.getItemDrop().remove();
            this.handleDrop();
        }
    }

    private void handleDrop() {
        if (SettingsManager.getConfig().getBoolean("Remove-Gadget-With-Drop")) {
            this.clear();
        }
    }

    private void handleClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        ItemStack current = event.getCurrentItem();
        if (player == this.getPlayer() && (this.isItemThis(current) || this.isItemThis(event.getCursor()))) {
            event.setCancelled(true);
            if (event.getAction().name().contains("DROP")) {
                this.handleDrop();
            }
        }
    }

    protected boolean isItemThis(ItemStack is) {
        return is != null && is.hasItemMeta() && is.getItemMeta().hasDisplayName() && is.getItemMeta().getDisplayName().equals(this.itemStack.getItemMeta().getDisplayName());
    }

    protected abstract ArmorSlot getArmorSlot();

    protected abstract String getOccupiedSlotKey();
}

