/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.config;

import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageManager {
    private static final SettingsManager messagesConfig;
    private static boolean success;

    public static boolean success() {
        return success;
    }

    private static void loadMessages(YamlConfiguration defaults) {
        ConfigurationSection menuBlock = messagesConfig.getConfigurationSection("Menu");
        if (menuBlock != null && menuBlock.isString("Gadgets")) {
            MessageManager.upgradeCategoryStrings(menuBlock);
        }
        String oldGadgetKey = "Treasure-Chests-Loot.gadget";
        String newGadgetKey = "Treasure-Chests-Loot.Gadget";
        String gadgetMessage = messagesConfig.getString(oldGadgetKey);
        if (gadgetMessage != null) {
            messagesConfig.set(newGadgetKey, gadgetMessage);
            messagesConfig.set(oldGadgetKey, null);
        }
        for (String key : defaults.getKeys(true)) {
            MessageManager.addMessage(key, defaults.getString(key));
        }
    }

    public static void addMessage(String path, String message) {
        messagesConfig.addDefault(path, message);
    }

    public static void save() {
        messagesConfig.save();
    }

    public static String getMessage(String messagePath) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)messagesConfig.getString(messagePath).replace("%prefix%", messagesConfig.getString("Prefix")));
    }

    private MessageManager() {
    }

    private static void upgradeCategoryStrings(ConfigurationSection menuBlock) {
        messagesConfig.set("Menu", null);
        HashMap<Category, Map<String, String>> buttons = new HashMap<Category, Map<String, String>>();
        HashMap<Category, String> menuNames = new HashMap<Category, String>();
        for (Category category : Category.values()) {
            HashMap<String, String> catSection = new HashMap<String, String>();
            catSection.put("Name", menuBlock.getString(category.getConfigPath()));
            buttons.put(category, catSection);
            menuNames.put(category, messagesConfig.getString("Menus." + category.getConfigPath()));
        }
        MessageManager.addButton(buttons, menuBlock, Category.PETS, "Spawn", "Despawn");
        MessageManager.addButton(buttons, menuBlock, Category.GADGETS, "Activate", "Deactivate");
        MessageManager.addButton(buttons, menuBlock, Category.EFFECTS, "Summon", "Unsummon");
        MessageManager.addButton(buttons, menuBlock, Category.MOUNTS, "Spawn", "Despawn");
        MessageManager.addButton(buttons, menuBlock, Category.MORPHS, "Morph", "Unmorph");
        MessageManager.addButton(buttons, menuBlock, Category.HATS, "Equip", "Unequip");
        MessageManager.addButton(buttons, menuBlock, Category.SUITS, "Equip", "Unequip");
        MessageManager.addButton(buttons, menuBlock, Category.EMOTES, "Equip", "Unequip");
        for (Map.Entry entry : buttons.entrySet()) {
            messagesConfig.set("Menu." + ((Category)((Object)entry.getKey())).getConfigPath() + ".Title", menuNames.get(entry.getKey()));
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                messagesConfig.set("Menu." + ((Category)((Object)entry.getKey())).getConfigPath() + ".Button." + (String)entry2.getKey(), entry2.getValue());
            }
        }
        messagesConfig.set("Menu.Main.Button.Name", menuBlock.getString("Main-Menu"));
        MessageManager.migrateKey("Menus.Main-Menu", "Menu.Main.Title");
        MessageManager.migrateKey("Menus.Buy-Ammo", "Menu.Buy-Ammo.Title");
        MessageManager.migrateKey("Menus.Rename-Pet", "Menu.Purchase-Rename.Title");
        MessageManager.migrateKey("Rename-Pet-Purchase", "Menu.Purchase-Rename.Button.Showcase");
        MessageManager.migrateKey("Rename-Pet", "Menu.Rename-Pet.Button.Name");
        MessageManager.migrateKey("Rename-Pet-Placeholder", "Menu.Rename-Pet.Placeholder");
        MessageManager.migrateKey("Rename-Pet-Title", "Menu.Rename-Pet.Title");
        MessageManager.migrateMiscButton(menuBlock, "Previous-Page");
        MessageManager.migrateMiscButton(menuBlock, "Next-Page");
        messagesConfig.set("Menus", null);
        MessageManager.migrateActivateMsg(Category.PETS, "Spawn", "Despawn");
        MessageManager.migrateActivateMsg(Category.EFFECTS, "Summon", "Unsummon");
        MessageManager.migrateActivateMsg(Category.MOUNTS, "Spawn", "Despawn");
        MessageManager.migrateActivateMsg(Category.MORPHS, "Morph", "Unmorph");
        MessageManager.migrateClearMsg("Cosmetics", "Cosmetics");
        for (Category category : Category.values()) {
            String configName = category.getMessagesName();
            MessageManager.migrateClearMsg(category.getConfigPath(), configName.substring(0, configName.length() - 1));
        }
    }

    private static void addButton(Map<Category, Map<String, String>> buttons, ConfigurationSection menuBlock, Category cat, String oldEquipKey, String oldUnequipKey) {
        buttons.get((Object)cat).put("Tooltip-Equip", menuBlock.getString(oldEquipKey));
        buttons.get((Object)cat).put("Tooltip-Unequip", menuBlock.getString(oldUnequipKey));
    }

    private static void migrateMiscButton(ConfigurationSection section, String key) {
        messagesConfig.set("Menu.Misc.Button." + key, section.getString(key));
    }

    private static void migrateActivateMsg(Category cat, String oldEquipKey, String oldUnequipKey) {
        MessageManager.migrateKey(cat.getConfigPath() + "." + oldEquipKey, cat.getConfigPath() + ".Equip");
        MessageManager.migrateKey(cat.getConfigPath() + "." + oldUnequipKey, cat.getConfigPath() + ".Unequip");
    }

    private static void migrateClearMsg(String newKey, String oldKey) {
        MessageManager.migrateKey("Clear-" + oldKey, "Clear." + newKey);
    }

    private static void migrateKey(String oldKey, String newKey) {
        messagesConfig.set(newKey, messagesConfig.getString(oldKey));
        messagesConfig.set(oldKey, null);
    }

    public static void reload() {
        messagesConfig.reload();
    }

    static {
        success = false;
        String langFile = "messages_" + UltraCosmeticsData.get().getLanguage();
        messagesConfig = new SettingsManager(langFile);
        if (messagesConfig.success()) {
            Reader reader = UltraCosmeticsData.get().getPlugin().getFileReader("messages/" + langFile + ".yml");
            MessageManager.loadMessages(YamlConfiguration.loadConfiguration((Reader)reader));
            messagesConfig.save();
            success = true;
        }
    }
}

