/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.config;

import be.isach.ultracosmetics.config.CustomConfiguration;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;

public class ManualCommentConfiguration
extends CustomConfiguration {
    private Map<String, List<String>> comments = new LinkedHashMap<String, List<String>>();
    private boolean newLineAfterHeader = false;
    private boolean newLinePerKey = false;

    private static String getPathToComment(List<String> configContents, int lineIndex, String configLine) {
        String trimmedConfigLine;
        if (configContents != null && lineIndex >= 0 && lineIndex < configContents.size() - 1 && configLine != null && (trimmedConfigLine = ManualCommentConfiguration.trimPrefixSpaces(configLine)).startsWith("#")) {
            int currentIndex = lineIndex;
            while (currentIndex < configContents.size() - 1) {
                String currentLine;
                String trimmedCurrentLine;
                if ((trimmedCurrentLine = ManualCommentConfiguration.trimPrefixSpaces(currentLine = configContents.get(++currentIndex))).startsWith("#")) continue;
                if (!trimmedCurrentLine.contains(":")) break;
                return ManualCommentConfiguration.getPathToKey(configContents, currentIndex, currentLine);
            }
        }
        return null;
    }

    private static String getPathToKey(List<String> configContents, int lineIndex, String configLine) {
        if (configContents != null && lineIndex >= 0 && lineIndex < configContents.size() && configLine != null && !configLine.startsWith("#") && configLine.contains(":")) {
            int spacesBeforeKey = ManualCommentConfiguration.getPrefixSpaceCount(configLine);
            String key = ManualCommentConfiguration.trimPrefixSpaces(configLine.substring(0, configLine.indexOf(58)));
            if (spacesBeforeKey > 0) {
                int currentIndex = lineIndex;
                int previousSpacesBeforeCurrentLine = -1;
                boolean atZeroSpaces = false;
                while (currentIndex > 0) {
                    String currentLine = configContents.get(--currentIndex);
                    int spacesBeforeCurrentLine = ManualCommentConfiguration.getPrefixSpaceCount(currentLine);
                    if (ManualCommentConfiguration.trim(currentLine).isEmpty()) break;
                    if (ManualCommentConfiguration.trim(currentLine).startsWith("#") || spacesBeforeCurrentLine >= spacesBeforeKey || !currentLine.contains(":")) continue;
                    if (spacesBeforeCurrentLine <= 0 && atZeroSpaces) break;
                    if (spacesBeforeCurrentLine == 0) {
                        atZeroSpaces = true;
                    }
                    if (previousSpacesBeforeCurrentLine != -1 && spacesBeforeCurrentLine >= previousSpacesBeforeCurrentLine) continue;
                    previousSpacesBeforeCurrentLine = spacesBeforeCurrentLine;
                    key = ManualCommentConfiguration.trimPrefixSpaces(currentLine.substring(0, currentLine.indexOf(":"))) + "." + key;
                }
            }
            return key;
        }
        return null;
    }

    private static int getPrefixSpaceCount(String aString) {
        int spaceCount = 0;
        if (aString != null && aString.contains(" ")) {
            for (char aCharacter : aString.toCharArray()) {
                if (aCharacter != ' ') break;
                ++spaceCount;
            }
        }
        return spaceCount;
    }

    private static String trim(String aString) {
        return aString != null ? aString.trim().replace(System.lineSeparator(), "") : "";
    }

    private static String trimPrefixSpaces(String aString) {
        if (aString != null) {
            while (aString.startsWith(" ")) {
                aString = aString.substring(1);
            }
        }
        return aString;
    }

    @Override
    public ConfigurationSection createSection(String path, String ... comments) {
        if (path != null && comments != null && comments.length > 0) {
            ArrayList<String> commentsList = new ArrayList<String>();
            for (String comment : comments) {
                if (comment != null) {
                    commentsList.add(comment);
                    continue;
                }
                commentsList.add("");
            }
            this.comments.put(path, commentsList);
        }
        return super.createSection(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException, InvalidConfigurationException {
        super.load(file);
        ArrayList<String> configLines = new ArrayList<String>();
        try (BufferedReader configReader = null;){
            String configReadLine;
            configReader = new BufferedReader(new FileReader(file));
            while ((configReadLine = configReader.readLine()) != null) {
                configLines.add(configReadLine);
            }
        }
        boolean hasHeader = configLines.size() < 2 || !ManualCommentConfiguration.trim((String)configLines.get(1)).isEmpty();
        LinkedHashMap<String, List<String>> configComments = new LinkedHashMap<String, List<String>>();
        for (int lineIndex = 0; lineIndex < configLines.size(); ++lineIndex) {
            String configKey;
            String configLine = (String)configLines.get(lineIndex);
            String trimmedLine = ManualCommentConfiguration.trimPrefixSpaces(configLine);
            if (!trimmedLine.startsWith("#") || lineIndex <= 0 && hasHeader || (configKey = ManualCommentConfiguration.getPathToComment(configLines, lineIndex, configLine)) == null) continue;
            ArrayList<String> keyComments = (ArrayList<String>)configComments.get(configKey);
            if (keyComments == null) {
                keyComments = new ArrayList<String>();
            }
            keyComments.add(trimmedLine.substring(trimmedLine.startsWith("# ") ? 2 : 1));
            configComments.put(configKey, keyComments);
        }
        this.comments = configComments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        super.save(file);
        ArrayList<String> configContent = new ArrayList<String>();
        try (BufferedReader configReader = null;){
            String configReadLine;
            configReader = new BufferedReader(new FileReader(file));
            while ((configReadLine = configReader.readLine()) != null) {
                configContent.add(configReadLine);
            }
        }
        try (BufferedWriter configWriter = null;){
            configWriter = new BufferedWriter(new FileWriter(file));
            configWriter.write("");
            for (int lineIndex = 0; lineIndex < configContent.size(); ++lineIndex) {
                String nextConfigLine;
                String configLine = (String)configContent.get(lineIndex);
                String configKey = null;
                if (!configLine.startsWith("#") && configLine.contains(":")) {
                    configKey = ManualCommentConfiguration.getPathToKey(configContent, lineIndex, configLine);
                }
                if (configKey != null && this.comments.containsKey(configKey)) {
                    int numOfSpaces = ManualCommentConfiguration.getPrefixSpaceCount(configLine);
                    String spacePrefix = "";
                    for (int i = 0; i < numOfSpaces; ++i) {
                        spacePrefix = spacePrefix + " ";
                    }
                    List<String> configComments = this.comments.get(configKey);
                    if (configComments != null) {
                        for (String comment : configComments) {
                            configWriter.append(spacePrefix).append("# ").append(comment);
                            configWriter.newLine();
                        }
                    }
                }
                configWriter.append(configLine);
                configWriter.newLine();
                boolean isComment = configLine.startsWith("#");
                if (this.newLineAfterHeader && lineIndex == 0 && isComment) {
                    configWriter.newLine();
                    continue;
                }
                if (!this.newLinePerKey || lineIndex >= configContent.size() - 1 || isComment || (nextConfigLine = (String)configContent.get(lineIndex + 1)) == null || nextConfigLine.startsWith(" ") || nextConfigLine.startsWith("'") || nextConfigLine.startsWith("-")) continue;
                configWriter.newLine();
            }
        }
    }

    @Override
    public void set(String key, Object value, String ... comments) {
        if (value != null) {
            if (comments != null) {
                if (comments.length > 0) {
                    ArrayList<String> commentsList = new ArrayList<String>();
                    for (String comment : comments) {
                        if (comment != null) {
                            commentsList.add(comment);
                            continue;
                        }
                        commentsList.add("");
                    }
                    this.comments.put(key, commentsList);
                } else {
                    this.comments.remove(key);
                }
            }
        } else {
            this.comments.remove(key);
        }
        super.set(key, value);
    }
}

