/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command.subcommands;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.UltraCosmeticsData;
import be.isach.ultracosmetics.command.SubCommand;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.player.UltraPlayer;
import be.isach.ultracosmetics.treasurechests.TreasureChestManager;
import be.isach.ultracosmetics.treasurechests.TreasureLocation;
import be.isach.ultracosmetics.util.BlockUtils;
import be.isach.ultracosmetics.version.VersionManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SubCommandTreasure
extends SubCommand {
    public SubCommandTreasure(UltraCosmetics ultraCosmetics) {
        super("treasure", "Starts Treasure Chest.", "[player] [<x> <y> <z>] [world]", ultraCosmetics);
    }

    @Override
    protected void onExeAnyone(CommandSender sender, String[] args) {
        VersionManager vm;
        World world;
        int z;
        int y;
        int x;
        Player opener;
        if (args.length < 2 && !(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "You must specify a player.");
            return;
        }
        if (args.length > 6) {
            sender.sendMessage(ChatColor.RED + "" + ChatColor.BOLD + "Incorrect Usage! " + this.getUsage());
            return;
        }
        if (args.length == 1) {
            opener = (Player)sender;
        } else {
            opener = Bukkit.getPlayer((String)args[1]);
            if (opener == null) {
                sender.sendMessage(ChatColor.RED + "" + ChatColor.BOLD + "Player " + args[1] + " not found!");
                return;
            }
        }
        UltraPlayer ultraPlayer = UltraCosmeticsData.get().getPlugin().getPlayerManager().getUltraPlayer(opener);
        if (ultraPlayer.getKeys() <= 0) {
            opener.closeInventory();
            ultraPlayer.openKeyPurchaseMenu();
            return;
        }
        if (args.length < 3) {
            if (!this.checkWorld(sender, opener.getWorld())) {
                return;
            }
            TreasureChestManager.tryOpenChest(opener);
            return;
        }
        try {
            x = Integer.parseInt(args[2]);
            y = Integer.parseInt(args[3]);
            z = Integer.parseInt(args[4]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(ChatColor.RED.toString() + ChatColor.BOLD + "Invalid coordinates!");
            return;
        }
        if (args.length > 5) {
            world = Bukkit.getWorld((String)args[5]);
            if (world == null) {
                sender.sendMessage(ChatColor.RED + "" + ChatColor.BOLD + "World " + args[5] + " doesn't exist!");
                return;
            }
        } else {
            world = opener.getWorld();
        }
        if (y >= (vm = UltraCosmeticsData.get().getVersionManager()).getWorldMaxHeight(world) || y <= vm.getWorldMinHeight(world)) {
            sender.sendMessage(MessageManager.getMessage("Chest-Location.Invalid"));
            return;
        }
        Location location = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
        Block block = location.getBlock();
        if (!this.isAir(block)) {
            sender.sendMessage(MessageManager.getMessage("Chest-Location.In-Ground"));
            for (int i = y; i < vm.getWorldMaxHeight(world); ++i) {
                if (!this.isAir(block.getWorld().getBlockAt(x, i, z))) continue;
                this.suggest(x, i, z, sender);
                break;
            }
            return;
        }
        if (this.isAir(block.getRelative(BlockFace.DOWN))) {
            sender.sendMessage(MessageManager.getMessage("Chest-Location.In-Air"));
            for (int i = y; i > vm.getWorldMinHeight(world); --i) {
                if (this.isAir(block.getWorld().getBlockAt(x, i, z))) continue;
                this.suggest(x, i + 1, z, sender);
                break;
            }
            return;
        }
        TreasureChestManager.tryOpenChest(opener, TreasureLocation.fromLocation(location));
    }

    private boolean checkWorld(CommandSender sender, World world) {
        if (SettingsManager.isAllowedWorld(world)) {
            return true;
        }
        sender.sendMessage(MessageManager.getMessage("World-Disabled"));
        return false;
    }

    private void suggest(int x, int y, int z, CommandSender sender) {
        sender.sendMessage(MessageManager.getMessage("Chest-Location.Suggestion").replace("%location%", x + "," + y + "," + z));
    }

    private boolean isAir(Block block) {
        return BlockUtils.isAir(block.getType());
    }
}

