/*
 * Decompiled with CFR 0.152.
 */
package be.isach.ultracosmetics.command.subcommands;

import be.isach.ultracosmetics.UltraCosmetics;
import be.isach.ultracosmetics.command.SubCommand;
import be.isach.ultracosmetics.config.MessageManager;
import be.isach.ultracosmetics.config.SettingsManager;
import be.isach.ultracosmetics.cosmetics.Category;
import be.isach.ultracosmetics.cosmetics.suits.ArmorSlot;
import be.isach.ultracosmetics.cosmetics.type.CosmeticType;
import be.isach.ultracosmetics.cosmetics.type.SuitType;
import be.isach.ultracosmetics.player.UltraPlayer;
import java.util.Arrays;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SubCommandToggle
extends SubCommand {
    private static final String ERROR_PREFIX = " " + ChatColor.RED + ChatColor.BOLD;

    public SubCommandToggle(UltraCosmetics ultraCosmetics) {
        super("toggle", "Toggles a cosmetic.", "<type> <cosmetic> [player]", ultraCosmetics, true);
    }

    @Override
    protected void onExePlayer(Player sender, String[] args) {
        if (args.length < 3 || args.length > 4) {
            sender.sendMessage(MessageManager.getMessage("Prefix") + ERROR_PREFIX + this.getUsage());
            return;
        }
        Player target = args.length > 3 ? Bukkit.getPlayer((String)args[3]) : sender;
        this.toggle((CommandSender)sender, target, args[1].toLowerCase(), args[2].toLowerCase());
    }

    @Override
    protected void onExeAnyone(CommandSender sender, String[] args) {
        if (args.length != 4) {
            sender.sendMessage(MessageManager.getMessage("Prefix") + ERROR_PREFIX + "/uc toggle <type> <cosmetic> <player>");
            return;
        }
        this.toggle(sender, Bukkit.getPlayer((String)args[3]), args[1].toLowerCase(), args[2].toLowerCase());
    }

    private void toggle(CommandSender sender, Player targetPlayer, String type, String cosm) {
        SuitType suitType;
        if (sender != targetPlayer && !sender.hasPermission(this.getPermission().getName() + ".others")) {
            this.error(sender, "You do not have permission to toggle cosmetics for others.");
            return;
        }
        UltraPlayer target = this.ultraCosmetics.getPlayerManager().getUltraPlayer(targetPlayer);
        if (target == null) {
            sender.sendMessage(MessageManager.getMessage("Prefix") + ERROR_PREFIX + "Invalid player.");
            return;
        }
        if (!SettingsManager.isAllowedWorld(target.getBukkitPlayer().getWorld())) {
            sender.sendMessage(MessageManager.getMessage("World-Disabled"));
            return;
        }
        Optional<Category> categories = Arrays.stream(Category.values()).filter(category -> category.isEnabled() && category.toString().toLowerCase().startsWith(type)).findFirst();
        if (!categories.isPresent()) {
            sender.sendMessage(MessageManager.getMessage("Prefix") + ERROR_PREFIX + "Invalid category.");
            return;
        }
        Category category2 = categories.get();
        boolean suits = category2 == Category.SUITS;
        ArmorSlot slot = null;
        if (suits) {
            try {
                slot = ArmorSlot.getByName(cosm.split(":")[1].toUpperCase());
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                sender.sendMessage(MessageManager.getMessage("Prefix") + ERROR_PREFIX + "/uc toggle suit <suit type:suit piece> <player>.");
                return;
            }
            target.removeSuit(slot);
        } else {
            target.removeCosmetic(category2);
        }
        Optional<CosmeticType> matchingType = category2.getEnabled().stream().filter(cosmeticType -> cosmeticType.isEnabled() && cosmeticType.toString().toLowerCase().contains(cosm.split(":")[0])).findFirst();
        if (!matchingType.isPresent()) {
            sender.sendMessage(MessageManager.getMessage("Prefix") + ERROR_PREFIX + "Invalid cosmetic.");
            return;
        }
        if (!suits) {
            matchingType.get().equip(target, this.ultraCosmetics);
            return;
        }
        try {
            suitType = SuitType.getSuitPart(cosm.split(":")[0], slot);
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(MessageManager.getMessage("Prefix") + ERROR_PREFIX + "/uc toggle suit <suit type:suit piece> <player>.");
            return;
        }
        suitType.equip(target, this.ultraCosmetics);
    }
}

